//会员信息完善页面  新的
define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    var checkAgreement = false;

    me.name = ko.observable("");
    me.code = ko.observable("");
    me.provinceHtml = ko.observable("");
    me.cityHtml = ko.observable("");
    me.areaHtml = ko.observable("");
    me.province = ko.observable("");
    me.city = ko.observable("");
    me.area = ko.observable("");
    me.address = ko.observable("");
    me.sendType = ko.observable("到付快递");
    //会员类型
    me.memberType = ko.observable("basic");
    //犬舍中文名
    me.kennelChinese = ko.observable("");
    //犬舍英文名
    me.kennelEnglish = ko.observable("");
    //推广号
    me.extendNumber = ko.observable("");
    //省List
    me.provinceList = ko.observableArray([]);
    //市List
    me.cityList = ko.observableArray([]);
    //区List
    me.areaList = ko.observableArray([]);
    me.chooseBasic = function() {
      $("#basic").removeClass();
      $("#basic").addClass("menberbox fl active");
      $("#professional").removeClass();
      $("#professional").addClass("menberbox fr");
      $("#dog_home").removeClass();
      $("#dog_home").addClass("dogbox_unactive");
      // $("#extend_box").removeClass();
      // $("#extend_box").addClass("dogbox_unactive");
      $("#memberType").val("basic");
      me.memberType("basic");
    };
    me.chooseProfessional = function() {
      $("#professional").removeClass();
      $("#professional").addClass("menberbox fr active");
      $("#basic").removeClass();
      $("#basic").addClass("menberbox fl");
      $("#dog_home").removeClass();
      $("#dog_home").addClass("dogbox_active");
      // $("#extend_box").removeClass();
      // $("#extend_box").addClass("dogbox_active item clearfix");
      $("#memberType").val("professional");
      me.memberType("professional");

      const memberCode = util.GetQueryValue("memberCode");
      if (memberCode) {
        me.extendNumber(memberCode);
      }
    };

    //犬舍输入验证
    me.vaildConfirmCZ = function(data) {
      if (util.isVal(me.kennelChinese()) == "") {
        $("#kennelChineseTishi").html(
          "<strong class='error'></strong><em style='color:red'>犬舍中文名称不能为空！</em>"
        );
      } else {
        console.log("me.kennelChinese()");
        $("#kennelChineseTishi").html("");
      }
    };
    me.vaildConfirmEN = function(data) {
      if (util.isVal(me.kennelChinese()) == "") {
        $("#kennelEnglishTishi").html(
          "<strong class='error'></strong><em style='color:red'>犬舍英文名称不能为空！</em>"
        );
      } else {
        console.log("me.kennelChinese()");
        $("#kennelEnglishTishi").html("");
      }
    };

    me.showSendType = function() {
      if ($("#sendType").css("display") == "none") {
        $("#sendType").css("display", "block");
      } else {
        $("#sendType").css("display", "none");
      }
    };

    //省份处理
    me.showProvince = function() {
      if ($("#provinceDiv").css("display") == "none") {
        $("#provinceDiv").css("display", "block");
      } else {
        $("#provinceDiv").css("display", "none");
      }
      $("#cityDiv").css("display", "none");
    };
    me.changeProvince = function(data) {
      me.provinceHtml(data.province);
      me.getCity(data.provinceId);
      $("#provinceDiv").css("display", "none");
    };
    //城市处理
    me.showCity = function() {
      if ($("#cityDiv").css("display") == "none") {
        $("#cityDiv").css("display", "block");
      } else {
        $("#cityDiv").css("display", "none");
      }
      $("#provinceDiv").css("display", "none");
    };
    me.changeCity = function(data) {
      me.cityHtml(data.city);
      me.getArea(data.cityId);
      $("#cityDiv").css("display", "none");
    };
    //区县处理
    me.showArea = function() {
      console.log("click");
      if ($("#areaDiv").css("display") == "none") {
        $("#areaDiv").css("display", "block");
      } else {
        $("#areaDiv").css("display", "none");
      }
      $("#provinceDiv").css("display", "none");
      $("#cityDiv").css("display", "none");
    };
    me.changeArea = function(data) {
      me.areaHtml(data.area);
      $("#areaDiv").css("display", "none");
    };

    me.check = function() {
      if ($("#checkAgreement").attr("class") == "radio checked") {
        $("#checkAgreement").removeClass();
        $("#checkAgreement").addClass("radio");
        checkAgreement = true;
      } else if ($("#checkAgreement").attr("class") == "radio") {
        $("#checkAgreement").removeClass();
        $("#checkAgreement").addClass("radio checked");
        checkAgreement = false;
      }
    };
    me.submit = function() {
      if ($("#memberType").val() == "professional") {
        if (util.isVal(me.kennelChinese()) == "") {
          layer.msg("请输入犬舍中文名");
          return;
        }
        if (util.isVal(me.kennelEnglish()) == "") {
          layer.msg("请输入犬舍英文名");
          return;
        }
      }

      if (util.isVal(me.name()) == "") {
        layer.msg("请填写姓名");
        return;
      }
      if (util.isVal(me.code()) == "") {
        layer.msg("请填写身份证号");
        return;
      } else if (!util.isCardNo(me.code())) {
        layer.msg("身份证号格式不正确");
        return;
      }
      if (util.isVal(me.address()) == "") {
        layer.msg("请填写详细地址");
        return;
      }
      if (checkAgreement) {
        //如果输入了 推荐编号 需要验证
        if (util.isVal(me.extendNumber()) != "") {
          var codeData = { token: "13413" };
          codeData["memberCode"] = me.extendNumber();
          util.sendAjax({
            url: "member/getMember",
            data: codeData,
            async: true,
            loadFlag: true,
            type: "GET",
            cache: false,
            success: function(result) {
              if (result.rc == 0) {
                var sendData = {};
                sendData["realName"] = me.name();
                sendData["idCard"] = me.code();
                util.sendAjax({
                  url: "open/getSessionMobile",
                  data: JSON.stringify(sendData),
                  async: true,
                  loadFlag: true,
                  type: "POST",
                  cache: false,
                  success: function(json) {
                    if (json.rc == 0) {
                      $("#confimPhone").html(json.data.mobile);
                      if ($("#memberType").val() == "basic") {
                        $("#cofimType").html("基础会员");
                        $("#cofimReferee").html(me.extendNumber());
                      } else if ($("#memberType").val() == "professional") {
                        $("#cofimType").html("繁育专业会员");

                        $("#cofimEnKennelName").html(me.kennelEnglish());
                        $("#cofimCnKennelName").html(me.kennelChinese());
                        $("#cofimReferee").html(me.extendNumber());
                      }
                      $("#confimName").html(me.name());
                      $("#confimCode").html(me.code());
                      $("#confimPost").html(me.sendType());
                      $("#confimAddress").html(
                        me.provinceHtml() +
                          me.cityHtml() +
                          me.areaHtml() +
                          me.address()
                      );
                      $("#confimMessage").show();
                    } else {
                      layer.msg("错误编码:" + json.rc + "错误信息:" + json.msg);
                    }
                  }
                });
              } else {
                layer.msg("推荐编号有误，不存在该会员");
              }
            }
          });
        } else {
          var sendData = {};
          sendData["realName"] = me.name();
          sendData["idCard"] = me.code();
          util.sendAjax({
            url: "open/getSessionMobile",
            data: JSON.stringify(sendData),
            async: true,
            loadFlag: true,
            type: "POST",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                $("#confimPhone").html(json.data.mobile);
                if ($("#memberType").val() == "basic") {
                  $("#cofimType").html("基础会员");
                } else if ($("#memberType").val() == "professional") {
                  $("#cofimType").html("繁育专业会员");

                  $("#cofimEnKennelName").html(me.kennelEnglish());
                  $("#cofimCnKennelName").html(me.kennelChinese());
                  $("#cofimReferee").html(me.extendNumber());
                }
                $("#confimName").html(me.name());
                $("#confimCode").html(me.code());
                $("#confimPost").html(me.sendType());
                $("#confimAddress").html(
                  me.provinceHtml() +
                    me.cityHtml() +
                    me.areaHtml() +
                    me.address()
                );
                $("#confimMessage").show();
              } else {
                layer.msg("错误编码:" + json.rc + "错误信息:" + json.msg);
              }
            }
          });
        }
      } else {
        layer.msg("请阅读并同意《会员注册须知》");
      }
    };
    me.returnData = function() {
      $("#confimMessage").hide();
    };
    me.changeSendType = function(data) {
      me.sendType(data);
      $("#sendType").css("display", "none");
    };
    me.submitAll = function() {
      var sendData = {};

      if ($("#memberType").val() == "professional") {
        //英文犬舍
        sendData["enKennelName"] = $("#cofimEnKennelName").html();
        //中文犬舍
        sendData["cnKennelName"] = $("#cofimCnKennelName").html();
      }
      //推荐编号
      sendData["referee"] = $("#cofimReferee").html();

      sendData["mobile"] = $("#confimPhone").html();
      sendData["newPassword"] = "123456";
      sendData["name"] = $("#confimPhone").html();
      sendData["loginName"] = $("#confimPhone").html();
      //会员类型
      sendData["memberType"] = $("#memberType").val();
      //姓名
      sendData["realName"] = me.name();
      //身份证号
      sendData["cardNo"] = me.code();
      //手机号
      sendData["phone"] = $("#confimPhone").html();
      //邮寄方式
      sendData["deliveryCertified"] = me.sendType();
      sendData["province"] = me.provinceHtml();
      sendData["city"] = me.cityHtml();
      sendData["area"] = me.areaHtml();
      sendData["street"] = me.address();

      util.sendAjax({
        url: "open/newRegister",
        data: JSON.stringify(sendData),
        async: false,
        type: "POST",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("注册成功！");
            window.location.href = "#/login/success";
          } else {
            layer.msg("注册失败,错误代码:" + json.rc + "错误信息:" + json.msg);
          }
        }
      });
    };

    //请求省列表
    me.getProvince = function() {
      var sendData = {};
      util.sendAjax(
        {
          url: "province/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.provinceList(json.items);
              me.provinceHtml(json.items[0].province);
              me.getCity(json.items[0].provinceId);
            } else {
              me.provinceList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    //请求市列表
    me.getCity = function(provinceId) {
      var sendData = {};
      sendData["province_code"] = provinceId;

      util.sendAjax(
        {
          url: "city/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.cityList(json.items);
              me.cityHtml(json.items[0].city);
              me.getArea(json.items[0].cityId);
            } else {
              me.cityList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    //请求区列表
    me.getArea = function(cityId) {
      var sendData = {};
      sendData["city_code"] = cityId;
      util.sendAjax(
        {
          url: "area/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.areaList(json.items);
              me.areaHtml(json.items[0].area);
            } else {
              me.areaList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    $(function() {
      me.getProvince();
    });
    context.app.loading(false);
  };
});
