//证书焕发添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //会员信息
        userInfo.refresh();
        me.member = ko.observable(userInfo.getMember());
        //犬种号
        me.dogBreed=ko.observable();
        //所属协会
        me.association= ko.observable();
        //外国血统证书号
        me.overseasPedigreeCertified = ko.observable();
        //犬名
        me.dogName = ko.observable();
        //芯片号
        me.dogChip = ko.observable();
        //犬毛色
        me.dogFurColor = ko.observable();
        //犬生日格式为2012-12-12
        me.dogBirthday = ko.observable();
        //犬性别：公1；母2
        me.dogGender = ko.observable("1");
        //价格 默认0
        me.price = ko.observable("0");
        //合作机构编号
        me.orgId = ko.observable("")
        //是否展开 默认都是否；
        me.openA = ko.observable(false);
        me.openB = ko.observable(false);
        //省List
        me.provinceList = ko.observableArray([]);
        me.provinceHtml = ko.observable("请选择地区");
        //机构列表
        me.hospitalList = ko.observableArray([]);
        //医院的显隐
        me.isShowHospital = ko.observable(false);
        me.hospitalText = ko.observable("请选择合作机构");
        //性别
        me.changeClass=function(type){
            $("#sex a").removeAttr("class");
            $("#sex"+type).attr("class","checked");
            me.dogGender(type);
        }
        //是否展开注意事项
        me.isOpen = ko.observable(false);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        //协会的显隐
        me.isShowAssociation= ko.observable(false);
        me.associationText = ko.observable("请选择协会");
        //犬种搜索值
        me.associationSearch = ko.observable("");
        me.associationRealList = ko.observableArray([]);
        //协会list
        me.associationList = ko.observableArray([]);
        me.associationHtml = ko.observable("请选择协会");
        //犬种的显隐
        me.isShowDogBreed= ko.observable(false);
        me.dogBreedText = ko.observable("请选择犬种");
        //犬种搜索值
        me.dogBreedSearch = ko.observable("");
        me.dogBreedRealList = ko.observableArray([]);
        //犬种list
        me.dogBreedList = ko.observableArray([]);
        me.dogBreedHtml = ko.observable("请选择犬种");
        //毛色
        me.dogColorMarkList = ko.observableArray([]);
        /**
         * 保存
         */
        me.saveCart = function(){
        	//选中的犬种
        	var dogBreed= $("#selectDogBreed").select2("val");
        	var dogBreeds=dogBreed.split("dogType-")[1];
        	//选中的协会
        	var association= $("#selectAssociation").select2("val");
        	//选中的毛色
        	var dogColor= $("#selectColorFlag").select2("val");
            var memberType = me.member().memberType;
            var isValid = new Date(new Date(util.formatDateShort(me.member().memberEndDate).replace(/-/g,"/"))).getTime()+86399000 - new Date().getTime() ;
            if(memberType=="professional"&&isValid>=0) {
                var sendData = {};
                if (util.isVal(dogBreeds) == "") {
                    layer.msg("犬种不能为空！");
                    return;
                }
                var overseasPedigreeCertified = me.overseasPedigreeCertified();
                if (util.isVal(me.overseasPedigreeCertified()) == "") {
                    layer.msg("国外证书号不能为空！");
                    return;
                }
                var dogName = me.dogName();
                if (util.isVal(dogName) == "") {
                    layer.msg("犬名不能为空！");
                    return;
                }else if(!util.isEnWord(dogName)){
                	layer.msg("犬名只能为英文");
                	return;
                }
                var orgId = me.orgId();
                if (util.isVal(orgId) == "") {
                    layer.msg("合作机构不能为空！");
                    return;
                }
                if (util.isVal(dogColor) == "") {
                    layer.msg("毛色不能为空！");
                    return;
                }
                var breedDate = $("#breedDate").val();
                if (util.isVal(breedDate) == "") {
                    layer.msg("出生日期不能为空！");
                    return;
                }
                sendData["dogBreed"] = dogBreeds;
                sendData["association"] = association;
                sendData["overseasPedigreeCertified"] = me.overseasPedigreeCertified();
                sendData["dogName"] = me.dogName();
                sendData["dogChip"] = me.dogChip();
                sendData["dogFurColor"] = dogColor;
                sendData["dogBirthday"] = $("#breedDate").val();
                sendData["dogGender"] = me.dogGender();
                sendData["orgId"]= me.orgId();
                sendData["orgId"]= me.orgId();
                sendData["stickerFlag"] = me.applyChecked() ? 1:0;
                util.sendAjax({
                    url: 'dog/dogpedigreecertifiedchange',
                    data: JSON.stringify(sendData),
                    async: true,
                    loadFlag: true,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("证书换发申请失败:" + json.msg);
                        }
                    }
                });
            }else{
                layer.msg("该业务仅限有效专业会员办理!");
            }

        }
        //证书换发订单金额
        me.getPrice = function(){
            var payData = {};
            payData["dogBreed"] = me.dogBreed().trim();
            if(payData["dogBreed"]!=undefined){
                util.sendAjax({
                    url:'dog/dogpedigreecertifiedchange/getPrice',
                    data:payData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc ==0){
                            me.price(json.data.price);
                        }else{
                            layer.msg("获取价格失败:"+json.msg);
                        }
                    }
                });
            }
        }
        //地址的选择
        me.showProvince = function(){
            var dogBreed= $("#selectDogBreed").select2("val");
            var dogBreeds=dogBreed.split("dogType-")[1];
            if (util.isVal(dogBreeds) == "") {
                layer.msg("请先选中犬种，再选择合作机构！");
                return;
            }
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{
                $("#provinceDiv").css("display","none");
            }
        }
        me.changeProvince = function(data){
            me.member().province = data;
            me.provinceHtml(data);
            me.hospitalText("请选择合作机构");
            me.orgId("");
            me.isShowHospital(false);
            for(var i = 0;i<util.city.length;i++){
                if(data==util.city[i].local){
                    me.initProCity(data);
                }
            }
            $("#provinceDiv").css("display","none");
            me.getHospital(data);
        }
        me.initProCity = function(province){
            me.provinceList().length = 0;
            for(var i = 0;i<util.city.length;i++){
                me.provinceList.push(util.city[i].local);
            }
        }
        //获取医院
        me.getHospital = function(province){
            var sendData = {};
            sendData["provinceName"] = province;
            sendData["mechanism"] = 'clubchange';
            //犬种
            var dogBreed= $("#selectDogBreed").select2("val");
            var dogBreeds=dogBreed.split("dogType-")[1];
            sendData["dogBreed"] = dogBreeds;
            util.sendAjax({
                url:'org',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length<=0){
                            $("#emptyShow").show();
                            me.hospitalList(data.list);
                        }else if(data.list.length>0){
                            $("#emptyShow").hide();
                            me.hospitalList(data.list);
                        }
                    }else{
                        layer.msg("合作机构列表查询失败:"+data.msg);
                    }
                }
            });
        }
        //医院的显示隐藏事件
        me.showHospital = function(){
            me.isShowHospital(!me.isShowHospital());
        }
        //选择医院
        me.chooseHospital = function(data,event){
        	me.orgId(data.id);
            me.hospitalText(data.name);
            $("#orgAddress").text("");
            $("#orgAddress").text(data.address+","+data.tel);
            me.isShowHospital(!me.isShowHospital());
            $("#allHospital li").removeAttr("class");
            $(event.target).parents("li").attr("class","active");
        }
        //协会的显隐
        me.showAssociationHtml  = function(){
            if($("#assciationDiv").css("display")=="none"){
                $("#assciationDiv").css("display","block");
            }else{
                $("#assciationDiv").css("display","none");
            }
        } 
        //协会列表
		me.initAssociationList= function(){
			util.sendAjax({
                url:'association',
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length<=0){
                        	me.associationList(data.list);
                        }else if(data.list.length>0){
                        	data.list.unshift({'name':"请选择协会","code":'' });
                        	me.associationList(data.list);
                            me.associationRealList(data.list.slice(0));
                        }
                    }else{
                        layer.msg("合作机构列表查询失败:"+data.msg);
                    }
                }
            });
		}
		//选中协会事件
		me.changeAssciation = function(data,event){
			 me.associationHtml(data.name);
			 $("#assciationDiv").css("display","none");
			 me.association(data.name);
		}
		//犬种列表初始化
		me.initDogBreedList = function(){
			util.sendAjax({
                url:'dog/dogtype/fci',
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length<=0){
                        }else if(data.list.length>0){
                        	data.list.unshift({'breedCnName':"请选择犬种","dogBreedCode":'' });
                        	me.dogBreedList(data.list);
                            me.dogBreedRealList(data.list.slice(0));
                        }
                    }else{
                        layer.msg("犬种列表查询失败:"+data.msg);
                    }
                }
            });
		}
        //犬种的显隐
        me.showDogBreedHtml  = function(){
            if($("#dogBreedDiv").css("display")=="none"){
                $("#dogBreedDiv").css("display","block");
            }else{
                $("#dogBreedDiv").css("display","none");
            }
        }

        //犬种搜索change事件
        me.dogBreedChange = function(data){
            if(util.isVal(me.dogBreedSearch())==""){
                me.dogBreedRealList(me.dogBreedList().slice(0));
            }
            me.dogBreedRealList.removeAll();
            for(var i=0;i<me.dogBreedList().length;i++){
                if(me.dogBreedList()[i].breedCnName.indexOf(me.dogBreedSearch())>-1){
                    me.dogBreedRealList.push(me.dogBreedList()[i]);
                }
            }
        }

        //协会选中事件
        me.associationChange = function(data){
            if(util.isVal(me.associationSearch())==""){
                me.associationRealList(me.associationList().slice(0));
            }
            me.associationRealList.removeAll();
            for(var i=0;i<me.associationList().length;i++){
                if(me.associationList()[i].name.indexOf(me.associationSearch())>-1){
                    me.associationRealList.push(me.associationList()[i]);
                }
            }
        }
        //犬种的毛色
        me.showDogColorHtml  = function(){
            if($("#dogColorMarkDiv").css("display")=="none"){
                $("#dogColorMarkDiv").css("display","block");
            }else{
                $("#dogColorMarkDiv").css("display","none");
            }
        }
        //选中犬种的毛色
        me.changeDogColor = function(data,event){
            me.dogFurColor(data.dogColorMarkCode);
            $("#dogColorMarkDiv").css("display","none");
        }
        /*宠爱护照及等级贴纸申请*/
        me.applyChecked = ko.observable(false);
        /*宠爱护照及等级贴纸申请*/
        me.toggleSelect = function(){
            me.applyChecked(!me.applyChecked());
        }
		//选中犬种事件
		me.changeDogBreed = function(data,event){
			var dogBreed= $("#selectDogBreed").select2("val");
			var dogBreeds=dogBreed.split("dogType-")[1];
			//初始化合作机构
            me.provinceHtml("请选择地区");
            me.initProCity();
            //医院的显隐
            me.isShowHospital(false);
            me.hospitalText("请选择合作机构");
            me.hospitalList([]);
            $("#orgAddress").text("");
			 if(dogBreeds!=''){
				 var payData = {};
				 payData["dogBreed"] = dogBreeds;
				 if(payData["dogBreed"]!=undefined){
					 util.sendAjax({
						 url:'dog/dogpedigreecertifiedchange/getPrice',
						 data:payData,
						 async:true,
						 loadFlag:true,
						 type:'GET',
						 cache:false,
						 success:function(json){
							 if(json.rc ==0){
								 me.price(json.data.price);
							 }else{
								 layer.msg("获取价格失败:"+json.msg);
							 }
						 }
					 });
				 }
				 //获取毛色
				 util.sendAjax({
					 url:'dog/dogcolormark/'+dogBreeds,
					 async:true,
					 loadFlag:true,
					 type:'GET',
					 cache:false,
					 success:function(data){
						 if(data.rc==0){
							 data.list.unshift({'dogColorMarkCn':"请选择毛色","dogColorMarkCode":'' });
							 me.dogColorMarkList(data.list);
						 }else{
							 layer.msg("犬只毛色查询失败:"+data.msg);
						 }
					 }
				 });


			 }
		}
        $(function(){
            /**
             * 初始化个人信息
             */
            me.member(userInfo.getMember());
            me.initProCity(me.member().province);
            //初始化协会，犬种列表
            me.initAssociationList();
            me.initDogBreedList();
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});