/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cache.ehcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(EhCache.class);
    private Ehcache cache;

    public EhCache(Ehcache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public V get(K key) throws CacheException {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Getting object from cache [" + this.cache.getName() + "] for key [" + key + "]");
            }
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Element for [" + key + "] is null.");
                }
                return null;
            }
            return (V)element.getObjectValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V put(K key, V value) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Putting object in cache [" + this.cache.getName() + "] for key [" + key + "]");
        }
        try {
            V previous = this.get(key);
            Element element = new Element(key, value);
            this.cache.put(element);
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V remove(K key) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Removing object from cache [" + this.cache.getName() + "] for key [" + key + "]");
        }
        try {
            V previous = this.get(key);
            this.cache.remove(key);
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Clearing all objects from cache [" + this.cache.getName() + "]");
        }
        try {
            this.cache.removeAll();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public int size() {
        try {
            return this.cache.getSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set<K> keys() {
        try {
            List keys = this.cache.getKeys();
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                return Collections.unmodifiableSet(new LinkedHashSet(keys));
            }
            return Collections.emptySet();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Collection<V> values() {
        try {
            List keys = this.cache.getKeys();
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                ArrayList<V> values = new ArrayList<V>(keys.size());
                for (Object key : keys) {
                    V value = this.get(key);
                    if (value == null) continue;
                    values.add(value);
                }
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public long getMemoryUsage() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getMemoryStoreSize() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public long getDiskStoreSize() {
        try {
            return this.cache.getDiskStoreSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public String toString() {
        return "EhCache [" + this.cache.getName() + "]";
    }
}

