/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ognl.Evaluation;
import org.apache.ibatis.ognl.SimpleNode;

public final class EvaluationPool {
    private List evaluations = new ArrayList();
    private int size = 0;
    private int created = 0;
    private int recovered = 0;
    private int recycled = 0;

    public EvaluationPool() {
        this(0);
    }

    public EvaluationPool(int initialSize) {
        int i = 0;
        while (i < initialSize) {
            this.evaluations.add(new Evaluation(null, null));
            ++i;
        }
        this.created = this.size = initialSize;
    }

    public Evaluation create(SimpleNode node, Object source) {
        return this.create(node, source, false);
    }

    public synchronized Evaluation create(SimpleNode node, Object source, boolean setOperation) {
        Evaluation result;
        if (this.size > 0) {
            result = (Evaluation)this.evaluations.remove(this.size - 1);
            result.init(node, source, setOperation);
            --this.size;
            ++this.recovered;
        } else {
            result = new Evaluation(node, source, setOperation);
            ++this.created;
        }
        return result;
    }

    public synchronized void recycle(Evaluation value) {
        if (value != null) {
            value.reset();
            this.evaluations.add(value);
            ++this.size;
            ++this.recycled;
        }
    }

    public void recycleAll(Evaluation value) {
        if (value != null) {
            this.recycleAll(value.getNext());
            this.recycleAll(value.getFirstChild());
            this.recycle(value);
        }
    }

    public void recycleAll(List value) {
        if (value != null) {
            int i = 0;
            int icount = value.size();
            while (i < icount) {
                this.recycle((Evaluation)value.get(i));
                ++i;
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCreatedCount() {
        return this.created;
    }

    public int getRecoveredCount() {
        return this.recovered;
    }

    public int getRecycledCount() {
        return this.recycled;
    }
}

