/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class OdpsLexer
extends Lexer {
    public static final Keywords DEFAULT_ODPS_KEYWORDS;

    public OdpsLexer(String input) {
        super(input);
        this.keywods = DEFAULT_ODPS_KEYWORDS;
    }

    @Override
    public void scanComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            while (true) {
                if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                    this.bufPos += 2;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = this.subString(this.mark + startHintSp, this.bufPos - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = this.subString(this.mark, this.bufPos);
                this.token = Token.MULTI_LINE_COMMENT;
                this.hasComment = true;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark + 1, this.bufPos);
            this.token = Token.LINE_COMMENT;
            this.hasComment = true;
            this.endOfComment = this.isEOF();
            return;
        }
    }

    @Override
    public void scanIdentifier() {
        char ch;
        char first = this.ch;
        boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new ParserException("illegal identifier");
        }
        this.mark = this.pos;
        this.bufPos = 1;
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        if (ch == '@') {
            ++this.bufPos;
            while ((ch = this.charAt(++this.pos)) == '-' || ch == '.' || CharTypes.isIdentifierChar(ch)) {
                ++this.bufPos;
            }
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("SHOW", Token.SHOW);
        map.put("PARTITION", Token.PARTITION);
        map.put("PARTITIONED", Token.PARTITIONED);
        map.put("OVERWRITE", Token.OVERWRITE);
        map.put("OVER", Token.OVER);
        DEFAULT_ODPS_KEYWORDS = new Keywords(map);
    }
}

