/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class EndEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EndEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EndEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EndNoneEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndErrorEvent", EndEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EndEvent.class, EndEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        EndEvent endEvent = (EndEvent)flowElement;
        List eventDefinitions = endEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "EndNoneEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "EndErrorEvent";
        }
        return "EndNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        EndEvent endEvent = (EndEvent)flowElement;
        this.addEventProperties((Event)endEvent, propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        EndEvent endEvent = new EndEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("EndErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)endEvent);
        }
        return endEvent;
    }
}

