/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiWrongDbException;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.ActivitiVersion;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.ListQueryParameterObject;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.db.upgrade.DbUpgradeStep;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.persistence.entity.PropertyEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.DeserializedObject;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);
    private static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    private static final List<ActivitiVersion> ACTIVITI_VERSIONS = new ArrayList<ActivitiVersion>();
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected List<PersistentObject> insertedObjects = new ArrayList<PersistentObject>();
    protected Map<Class<?>, Map<String, CachedObject>> cachedObjects = new HashMap();
    protected List<DeleteOperation> deleteOperations = new ArrayList<DeleteOperation>();
    protected List<DeserializedObject> deserializedObjects = new ArrayList<DeserializedObject>();
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;
    public static String[] JDBC_METADATA_TABLE_TYPES;

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void touch(PersistentObject persistentObject) {
        if (persistentObject.getId() == null) {
            throw new ActivitiException("Cannot touch " + persistentObject.getClass() + " with no id");
        }
        if (this.insertedObjects.contains(persistentObject)) {
            this.insertedObjects.remove(persistentObject);
            this.insertedObjects.add(persistentObject);
            this.cachePut(persistentObject, false);
        }
    }

    public void insert(PersistentObject persistentObject) {
        if (persistentObject.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            persistentObject.setId(id);
        }
        this.insertedObjects.add(persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void update(PersistentObject persistentObject) {
        this.cachePut(persistentObject, false);
    }

    public void update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        this.getSqlSession().update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter) {
        this.deleteOperations.add(new BulkDeleteOperation(statement, parameter));
    }

    public void delete(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            log.debug("skipping redundant delete: {}", (Object)persistentObject);
            return;
        }
        this.deleteOperations.add(new CheckedDeleteOperation(persistentObject));
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof PersistentObject) {
            PersistentObject loadedObject = (PersistentObject)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public <T extends PersistentObject> T selectById(Class<T> entityClass, String id) {
        PersistentObject persistentObject = (PersistentObject)this.cacheGet(entityClass, id);
        if (persistentObject != null) {
            return (T)persistentObject;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        persistentObject = (PersistentObject)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (persistentObject == null) {
            return null;
        }
        this.cachePut(persistentObject, true);
        return (T)persistentObject;
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!(loadedObjects.get(0) instanceof PersistentObject)) {
            return loadedObjects;
        }
        ArrayList<PersistentObject> filteredObjects = new ArrayList<PersistentObject>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            PersistentObject cachedPersistentObject = this.cacheFilter((PersistentObject)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected CachedObject cachePut(PersistentObject persistentObject, boolean storeState) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObject.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedObject>();
            this.cachedObjects.put(persistentObject.getClass(), classCache);
        }
        CachedObject cachedObject = new CachedObject(persistentObject, storeState);
        classCache.put(persistentObject.getId(), cachedObject);
        return cachedObject;
    }

    protected PersistentObject cacheFilter(PersistentObject persistentObject) {
        PersistentObject cachedPersistentObject = (PersistentObject)this.cacheGet(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.cachePut(persistentObject, true);
        return persistentObject;
    }

    protected <T> T cacheGet(Class<T> entityClass, String id) {
        CachedObject cachedObject = null;
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getPersistentObject();
        }
        return null;
    }

    protected void cacheRemove(Class<?> persistentObjectClass, String persistentObjectId) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObjectClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(persistentObjectId);
    }

    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<PersistentObject> entities = new ArrayList<PersistentObject>(classCache.size());
            for (CachedObject cachedObject : classCache.values()) {
                entities.add(cachedObject.getPersistentObject());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public <T> T findInCache(Class<T> entityClass, String id) {
        return this.cacheGet(entityClass, id);
    }

    public void addDeserializedObject(Object deserializedObject, byte[] serializedBytes, VariableInstanceEntity variableInstanceEntity) {
        this.addDeserializedObject(new DeserializedObject(deserializedObject, serializedBytes, variableInstanceEntity));
    }

    public void addDeserializedObject(DeserializedObject deserializedObject) {
        this.deserializedObjects.add(deserializedObject);
    }

    @Override
    public void flush() {
        this.removeUnnecessaryOperations();
        this.flushDeserializedObjects();
        List<PersistentObject> updatedObjects = this.getUpdatedObjects();
        if (log.isDebugEnabled()) {
            log.debug("flush summary: {} insert, {} update, {} delete.", new Object[]{this.insertedObjects.size(), updatedObjects.size(), this.deleteOperations.size()});
            for (PersistentObject insertedObject : this.insertedObjects) {
                log.debug("  insert {}", (Object)insertedObject);
            }
            for (PersistentObject updatedObject : updatedObjects) {
                log.debug("  update {}", (Object)updatedObject);
            }
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                log.debug("  {}", (Object)deleteOperation);
            }
            log.debug("now executing flush...");
        }
        this.flushInserts();
        this.flushUpdates(updatedObjects);
        this.flushDeletes();
    }

    protected void removeUnnecessaryOperations() {
        Iterator<DeleteOperation> deleteIt = this.deleteOperations.iterator();
        while (deleteIt.hasNext()) {
            DeleteOperation deleteOperation = deleteIt.next();
            Iterator<PersistentObject> insertIt = this.insertedObjects.iterator();
            while (insertIt.hasNext()) {
                PersistentObject insertedObject = insertIt.next();
                if (!deleteOperation.sameIdentity(insertedObject)) continue;
                insertIt.remove();
                deleteIt.remove();
            }
            deleteOperation.clearCache();
        }
        for (PersistentObject insertedObject : this.insertedObjects) {
            this.cacheRemove(insertedObject.getClass(), insertedObject.getId());
        }
    }

    protected void flushDeserializedObjects() {
        for (DeserializedObject deserializedObject : this.deserializedObjects) {
            deserializedObject.flush();
        }
    }

    public List<PersistentObject> getUpdatedObjects() {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        for (Class<?> clazz : this.cachedObjects.keySet()) {
            Map<String, CachedObject> classCache = this.cachedObjects.get(clazz);
            for (CachedObject cachedObject : classCache.values()) {
                PersistentObject persistentObject = cachedObject.getPersistentObject();
                if (this.isPersistentObjectDeleted(persistentObject)) continue;
                Object originalState = cachedObject.getPersistentObjectState();
                if (!persistentObject.getPersistentState().equals(originalState)) {
                    updatedObjects.add(persistentObject);
                    continue;
                }
                log.trace("loaded object '{}' was not updated", (Object)persistentObject);
            }
        }
        return updatedObjects;
    }

    protected boolean isPersistentObjectDeleted(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            return true;
        }
        return false;
    }

    public <T extends PersistentObject> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<T> prunedList = new ArrayList<T>(listToPrune);
        for (PersistentObject potentiallyDeleted : listToPrune) {
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                if (!deleteOperation.sameIdentity(potentiallyDeleted)) continue;
                prunedList.remove(potentiallyDeleted);
            }
        }
        return prunedList;
    }

    protected void flushInserts() {
        for (PersistentObject insertedObject : this.insertedObjects) {
            String insertStatement = this.dbSqlSessionFactory.getInsertStatement(insertedObject);
            if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
                throw new ActivitiException("no insert statement for " + insertedObject.getClass() + " in the ibatis mapping files");
            }
            log.debug("inserting: {}", (Object)insertedObject);
            this.sqlSession.insert(insertStatement, (Object)insertedObject);
            if (!(insertedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)insertedObject)).setRevision(((HasRevision)((Object)insertedObject)).getRevisionNext());
        }
        this.insertedObjects.clear();
    }

    protected void flushUpdates(List<PersistentObject> updatedObjects) {
        for (PersistentObject updatedObject : updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ActivitiException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            log.debug("updating: {}", (Object)updatedObject);
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords != 1) {
                throw new ActivitiOptimisticLockingException(updatedObject + " was updated by another transaction concurrently");
            }
            if (!(updatedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        updatedObjects.clear();
    }

    protected void flushDeletes() {
        for (DeleteOperation delete : this.deleteOperations) {
            log.debug("executing: {}", (Object)delete);
            delete.execute();
        }
        this.deleteOperations.clear();
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"5.15.1".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.15.1", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (errorMessage != null) {
                throw new ActivitiException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ActivitiException("no activiti tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in activiti.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ActivitiException("couldn't get db schema version", e);
        }
        log.debug("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"5.15.1".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.15.1", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
    }

    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.isIdentityTablePresent() && this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = this.selectById(PropertyEntity.class, "schema.version");
            String dbVersion = dbVersionProperty.getValue();
            int index = 0;
            while (matchingVersionIndex < 0 && index < ACTIVITI_VERSIONS.size()) {
                if (ACTIVITI_VERSIONS.get(index).matches(dbVersion)) {
                    matchingVersionIndex = index;
                    continue;
                }
                ++index;
            }
            if (matchingVersionIndex < 0) {
                throw new ActivitiException("Could not update Activiti database schema: unknown version from database: '" + dbVersion + "'");
            }
            boolean bl = isUpgradeNeeded = matchingVersionIndex != ACTIVITI_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("5.15.1");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = new PropertyEntity("schema.history", "create(5.0)");
                    this.insert(dbHistoryProperty);
                } else {
                    dbHistoryProperty = this.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "5.15.1" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", matchingVersionIndex);
                feedback = "upgraded Activiti from " + dbVersion + " to " + "5.15.1";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.isIdentityTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("identity", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        return feedback;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        if (!this.dbSqlSessionFactory.isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        try {
            tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tables.close();
                }
                catch (Exception e) {
                    log.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ActivitiException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        try {
            tables.close();
        }
        catch (Exception e) {
            log.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("5.15.1".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("5.15.1");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new ActivitiException("Version of activiti database (" + versionInDatabase + ") is more recent than the engine (" + "5.15.1" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            log.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"5.15.1");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex) {
        ActivitiVersion activitiVersion = ACTIVITI_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = activitiVersion.getMainVersion();
        log.info("upgrading activiti {} schema from {} to {}", new Object[]{component, dbVersion, "5.15.1"});
        for (int i = currentDatabaseVersionsIndex + 1; i < ACTIVITI_VERSIONS.size(); ++i) {
            String nextVersion = ACTIVITI_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            log.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component), true);
            dbVersion = nextVersion;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/activiti/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ActivitiException("resource '" + resourceName + "' is not available");
                log.info("no schema resource {} for {}", (Object)resourceName, (Object)operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            try {
                String databaseType = this.dbSqlSessionFactory.getDatabaseType();
                if (databaseType.equals("mysql")) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    log.info("Found MySQL: majorVersion=" + majorVersion + " minorVersion=" + minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                log.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.debug(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (ActivitiException e) {
                            throw new ActivitiException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), e);
                        }
                        try {
                            log.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute(this);
                        }
                        catch (Exception e) {
                            throw new ActivitiException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), e);
                        }
                    }
                    if (line.length() > 0) {
                        if (line.endsWith(";")) {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                log.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                log.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.debug("activiti db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ModelQueryImpl createModelQueryImpl() {
        return new ModelQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new UserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new GroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    static {
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.7"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.8"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.9"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.10"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.11"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.12", Arrays.asList("5.12.1", "5.12T")));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.13"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.14"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15.1"));
        JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    }

    public static class CachedObject {
        protected PersistentObject persistentObject;
        protected Object persistentObjectState;

        public CachedObject(PersistentObject persistentObject, boolean storeState) {
            this.persistentObject = persistentObject;
            if (storeState) {
                this.persistentObjectState = persistentObject.getPersistentState();
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public Object getPersistentObjectState() {
            return this.persistentObjectState;
        }
    }

    public class CheckedDeleteOperation
    implements DeleteOperation {
        protected final PersistentObject persistentObject;

        public CheckedDeleteOperation(PersistentObject persistentObject) {
            this.persistentObject = persistentObject;
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return this.persistentObject.getClass().equals(other.getClass()) && this.persistentObject.getId().equals(other.getId());
        }

        @Override
        public void clearCache() {
            DbSqlSession.this.cacheRemove(this.persistentObject.getClass(), this.persistentObject.getId());
        }

        @Override
        public void execute() {
            String deleteStatement = DbSqlSession.this.dbSqlSessionFactory.getDeleteStatement(this.persistentObject.getClass());
            if ((deleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ActivitiException("no delete statement for " + this.persistentObject.getClass() + " in the ibatis mapping files");
            }
            if (this.persistentObject instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
                if (nrOfRowsDeleted == 0) {
                    throw new ActivitiOptimisticLockingException(this.persistentObject + " was updated by another transaction concurrently");
                }
            } else {
                DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public String toString() {
            return "delete " + this.persistentObject;
        }
    }

    public class BulkDeleteOperation
    implements DeleteOperation {
        private String statement;
        private Object parameter;

        public BulkDeleteOperation(String statement, Object parameter) {
            this.statement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(statement);
            this.parameter = parameter;
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return false;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void execute() {
            DbSqlSession.this.sqlSession.delete(this.statement, this.parameter);
        }

        public String toString() {
            return "bulk delete: " + this.statement + "(" + this.parameter + ")";
        }
    }

    public static interface DeleteOperation {
        public boolean sameIdentity(PersistentObject var1);

        public void clearCache();

        public void execute();
    }
}

