<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>天猫护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script src="${ctxStatic}/city.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            var  provinceText = "<option value=''>--省--</option>";
            for (var i=0;i<iosProvinces.length;i++){
                provinceText += '<option value="'+iosProvinces[i].value+'">'+iosProvinces[i].value+'</option>'
            }
            $('#province').html(provinceText);

            $('#province').change(function(){
                console.log('456')
                city($('#province option:selected') .val());
            });
            $('#city').change(function(){
                $('#county').empty();
                county($('#city option:selected') .val());
            });
            var city = function(a){
                var  cityText = "<option value=''>--市--</option>";
                for (var i=0;i<iosCitys.length;i++){
                    if(iosCitys[i].parentName == a){
                        cityText += '<option value="'+iosCitys[i].value+'">'+iosCitys[i].value+'</option>'
                    }
                }
                $('#city').html(cityText);
                $('#city').val('').select2();
                $('#county').html("<option value=''>--区(县)--</option>");
                $('#county').val('').select2();
            }
            var county = function(a){
                var  countyText = "<option value=''>--区(县)--</option>";
                for (var i=0;i<iosCountys.length;i++){
                    if(iosCountys[i].parentName == a){
                        countyText += '<option value="'+iosCountys[i].value+'">'+iosCountys[i].value+'</option>'
                    }
                }
                $('#county').html(countyText);
                $('#county').val('').select2();
            }
            $('#province').val('${passportOrder.consigneeProvince}').select2();
            city('${passportOrder.consigneeProvince}');
            $('#city').val('${passportOrder.consigneeCity}').select2();
            county('${passportOrder.consigneeCity}');
            $('#county').val('${passportOrder.consigneeDistrict}').select2();
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/passportOrder/tmall">天猫护照订单管理</a></li>
    <li class="active"><a href="#">护照订单添加</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/tmall/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">旺旺ID：</label>
        <div class="controls">
            <form:input path="wangwangId" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">订单号：</label>
        <div class="controls">
            <form:input path="tmallOrderCode" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">姓名：</label>
        <div class="controls">
            <form:input path="consigneeName" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">手机号码：</label>
        <div class="controls">
            <form:input path="consigneePhone" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">固定电话：</label>
        <div class="controls">
            <form:input path="consigneeLandline" htmlEscape="false" maxlength="50" class="input-xlarge"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">收货地址：</label>
        <div class="controls">
            <%--<form:input path="consigneeProvince" htmlEscape="false" maxlength="50"  class="input-medium required"/>省--%>
            <%--<form:input path="consigneeCity" htmlEscape="false" maxlength="50" class="input-medium required"/>市--%>
            <%--<form:input path="consigneeDistrict" htmlEscape="false" maxlength="50" class="input-medium required"/>区(县)--%>
                <select id="province" class="input-small required" name="consigneeProvince">
                    <option value="">--省--</option>
                </select>
                <select id="city" class="input-small required" name="consigneeCity">
                    <option value="">--市--</option>
                </select>
                <select id="county" class="input-small required" name="consigneeDistrict">
                    <option value="">--区(县)--</option>
                </select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">详细地址：</label>
        <div class="controls">
            <form:input path="consigneeAddress" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">下单时间：</label>
        <div class="controls">
            <input name="orderTime" type="text" readonly="readonly" maxlength="30" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm',isShowClear:true});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">购买套餐：</label>
        <div class="controls">
            <form:select path="packageType" class="input-medium required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('passport_order_package_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">重量：</label>
        <div class="controls">
            <form:input path="expressWeight" htmlEscape="false" maxlength="50" class="input-xlarge "/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名称：</label>
        <div class="controls">
            <form:input path="petName" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">种类：</label>
        <div class="controls">
            <form:select path="petType" class="input-medium required" id="petType" >
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('pet_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
            <form:select path="petGender" class="input-medium required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('pet_gender')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <input name="petBirthday" type="text" readonly="readonly" maxlength="30" class="input-medium Wdate required"
            value="<fmt:formatDate value="${passportOrder.petBirthday}" pattern="yyyy-MM-dd"/>"
            onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">毛色：</label>
        <div class="controls">
            <form:input path="petCoatColor" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="passportOrder:tmall:edit">
            <input id="btnSubmit" class="btn btn-primary"type="submit"value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>