/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.cab.passport.marketing.service.CatFeedConfig;
import com.cab.passport.sys.util.MD5Util;
import com.cab.passport.votes.dao.SchoolDao;
import com.cab.passport.votes.dao.VoteUserDao;
import com.cab.passport.votes.dao.VotesDao;
import com.cab.passport.votes.entity.School;
import com.cab.passport.votes.entity.VoteUser;
import com.cab.passport.votes.entity.Votes;
import com.github.wxpay.sdk.WXPayUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.modules.sys.entity.User;

import net.sf.json.JSONObject;

/**
 * votesService
 * @author wj
 * @version 2020-05-12
 */
@Service
@Transactional(readOnly = true)
public class VotesService extends CrudService<VotesDao, Votes> {

	public static final String REFRESH_TOKEN = "access_token";


	@Autowired
	private VoteUserDao voteUserDao;
	@Autowired
	private RestTemplate restTemplate;
	@Autowired
	private CatFeedConfig catConfig;
	@Autowired
	private SchoolDao schoolDao;
	@Autowired
	private VotesDao votesDao;
	@Autowired
	private  VoteUserService voteUserService;


	public Votes get(String id) {
		return super.get(id);
	}

	public List<Votes> findList(Votes votes) {
		return super.findList(votes);
	}

	public Page<Votes> findPage(Page<Votes> page, Votes votes) {
		return super.findPage(page, votes);
	}

	@Transactional(readOnly = false)
	public void save(Votes votes) {
		super.save(votes);
	}

	@Transactional(readOnly = false)
	public void delete(Votes votes) {
		super.delete(votes);
	}

	@Transactional(readOnly = false)
    public RESTResponse saveVotes(HttpServletRequest request,String json) {
		JSONObject jo = JSONObject.fromObject(json);
		// 获取参数
		String wxOpenId = jo.getString("wxOpenId");
		String schoolCode = jo.getString("id");
		VoteUser voteUser = voteUserDao.getByOpenId(wxOpenId);
		User user = new User();
		user.setId("1");
		if(voteUser == null ){
			String substring = wxOpenId.substring(7, wxOpenId.length());
			String str = MD5Util.MD5Encode(substring, "UTF-8");
			if(!wxOpenId.substring(0,5).equals(str.substring(0,5))){
				throw new ZAException("错误请求");
			}
			voteUser = new VoteUser();
			voteUser.setOpenId(wxOpenId);
			voteUser.setTotalVotes("100");
			voteUser.setRemainingVotes("100");
			voteUserService.saveVoteUser(voteUser);
		}
//		保存投票记录
		String totalVotes = voteUser.getTotalVotes();
		int remain = Integer.parseInt(voteUser.getRemainingVotes());

		if (StringUtils.isNotBlank(voteUser.getSchoolCode()) && !voteUser.getSchoolCode().equals(schoolCode)) {
			String schoolName = schoolDao.getByCode(voteUser.getSchoolCode()).getSchoolName();
			throw new ZAException("您已投喂过"+ schoolName +"的校宠，请善始善终哦");
		}
		JSONObject jsonObject = new JSONObject();
		School school = schoolDao.getByCode(schoolCode);
		if (StringUtils.isNotBlank(voteUser.getRemainingVotes()) && remain > 0) {
			Votes votes = new Votes();
			votes.setSchoolCode(schoolCode);
			votes.setVoteUser(voteUser);
			String votesNum = getVotesNum(voteUser);
			votes.setVotes(votesNum);
			votes.setCreateBy(user);
			votes.preInsert();

////		喂猫后保存用户
			voteUser.setSchoolCode(schoolCode);
			voteUser.setNum((Integer.parseInt(voteUser.getNum())+1)+"");
			int remainingVotes = remain - Integer.parseInt(votesNum);
			voteUser.setRemainingVotes(remainingVotes+"");
			voteUser.preUpdate();
			voteUserDao.update(voteUser);
//
////		修改学校票数
			int schoolvotes = Integer.parseInt(school.getVotes()) + Integer.parseInt(votesNum);
			school.setVotes(schoolvotes+"");
			school.preUpdate();
			schoolDao.update(school);

			dao.insert(votes);

			if(remainingVotes > 0){
				jsonObject.put("type", "0");
			}else{
				jsonObject.put("type", "1");
			}
			jsonObject.put("totalVotes", totalVotes);
			jsonObject.put("thisVotes", votesNum);
			jsonObject.put("votes", schoolvotes);
		}else{
			jsonObject.put("type", "1");
			jsonObject.put("totalVotes", totalVotes);
			jsonObject.put("thisVotes", "0");
			jsonObject.put("votes", school.getVotes());
		}
		return new RESTResponse(jsonObject);
	}


	public static final String[] VOTE = {"100","70","30","10"};

	private String getVotesNum(VoteUser voteUser) {
		String vote = "0";
		int num = Integer.parseInt(voteUser.getNum());
		String remainingVotes = voteUser.getRemainingVotes();
		if(num == 0){
			int index=(int)(Math.random()*VOTE.length);
			vote =  VOTE[index];
		}else{
			List<Object> list = new ArrayList();
			for(int i= 0; i< VOTE.length; i++){
				int v = Integer.parseInt(VOTE[i]);
				if(v <= Integer.parseInt(remainingVotes)){
					list.add(v);
				}
			}
			for (Object obj : list){
				if( num+1 <= 5){
					vote = obj+"";
				}
				break;
			}

		}
		return vote;
	}

	public JSONObject getTicket(String url) throws Exception {
		CatFeedConfig config = catConfig;
		String URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + config.getAppID()
				+ "&secret=" + config.getKey();

		String t = restTemplate.getForEntity(URL, String.class).getBody();

		HashMap<String, String> tmap = JSON.parseObject(t, HashMap.class);
		String URL2 = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + tmap.get("access_token")
				+ "&type=jsapi";
		String body = restTemplate.getForEntity(URL2, String.class).getBody();
		HashMap<String, String> map = JSON.parseObject(body, HashMap.class);
		if (StringUtils.isBlank(map.get("ticket"))) {
			throw new ZAException("获取票据失败!");
		}
		String noncestr = WXPayUtil.generateNonceStr();
		String timestamp = String.valueOf(System.currentTimeMillis()).toString().substring(0, 10);

		StringBuilder sb = new StringBuilder("jsapi_ticket=");
		sb.append(map.get("ticket"));
		sb.append("&noncestr=");
		sb.append(noncestr);
		sb.append("&timestamp=");
		sb.append(timestamp);
		sb.append("&url=");
		sb.append(url);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("appId", config.getAppID());
		jsonObject.put("noncestr", noncestr);
		jsonObject.put("timestamp", timestamp);
		jsonObject.put("signature", DigestUtils.sha1Hex(sb.toString()));
		return jsonObject;

	}
	public JSONObject getUser(HttpServletRequest request,String wxOpenId,String accessToken) throws Exception{
		CatFeedConfig config = catConfig;
//		获取token
		String tokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + config.getAppID()
				+ "&secret=" + config.getKey();
		String body2 = restTemplate.getForEntity(tokenUrl, String.class).getBody();
		HashMap<String, String> map2 = JSON.parseObject(body2, HashMap.class);

		String subscribers = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + map2.get("access_token")
				+ "&openid="+ wxOpenId +"&lang=zh_CN";
		String url3 = restTemplate.getForEntity(subscribers, String.class).getBody();
		String body3  = new String(url3.getBytes("ISO-8859-1"),"UTF-8");
		HashMap map3 = JSON.parseObject(body3, HashMap.class);
		JSONObject jsonObject = new JSONObject();
		Integer subscribe = (Integer) map3.get("subscribe");
		if(subscribe == null || subscribe.equals("0") || subscribe == 0){
			String sub = "https://api.weixin.qq.com/sns/userinfo?access_token=" + accessToken
					+ "&openid="+ wxOpenId +"&lang=zh_CN";
			String url4 = restTemplate.getForEntity(sub, String.class).getBody();
			String body4  = new String(url4.getBytes("ISO-8859-1"),"UTF-8");
			HashMap map4 = JSON.parseObject(body4, HashMap.class);
			String nickname = (String) map4.get("nickname");
			jsonObject.put("nickname", nickname);
			jsonObject.put("openid", wxOpenId);
			jsonObject.put("subscribe","0");
		}else{
			String nickname = (String) map3.get("nickname");
			jsonObject.put("nickname", nickname);
			jsonObject.put("openid", wxOpenId);
			jsonObject.put("subscribe",subscribe+"");
		}
		return jsonObject;
	}

	public JSONObject getUserInfo(String json,HttpServletRequest request) throws Exception {
		JSONObject jo = JSONObject.fromObject(json);
		String code = jo.getString("code");
		CatFeedConfig config = catConfig;
		String URL = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code&appid=" + config.getAppID()
				+ "&secret=" + config.getKey() + "&code=";
		String body = restTemplate.getForEntity(URL + code, String.class).getBody();
		HashMap<String, String> map = JSON.parseObject(body, HashMap.class);
		if (!map.containsKey("openid")) {
			logger.info("获取openId失败");
			throw new ZAException("获取openID失败！请重新获取code！");
		}
		String wxOpenId = map.get("openid");

		JSONObject jsonObject = getUser(request, wxOpenId, map.get("access_token"));
		return jsonObject;
	}


}