<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>寻宠寻主管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/petLostAndFound/">寻宠寻主列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="petLostAndFound" action="${ctx}/petLostAndFound/"
           method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>宠物芯片号：</label>
            <form:input path="identificationFlagLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>编号：</label>
            <form:input path="lostAndFoundCodeLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>城市：</label>
            <form:input path="cityLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>寻宠/寻主：</label>
            <form:select path="lostAndFoundType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('lost_and_found_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>审核状态：</label>
            <form:select path="reviewState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('lost_and_found_review_state')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>宠物芯片号</th>
        <th>寻宠/寻主</th>
        <th>编号</th>
        <th>宠物种类</th>
        <th>性别</th>
        <th>城市</th>
        <th>联系人</th>
        <th>手机号</th>
        <th>审核状态</th>
        <th>审核</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="petLostAndFound">
        <tr>
            <td>
                    ${petLostAndFound.identificationFlag}
            </td>
            <td>
                    ${fns:getDictLabel(petLostAndFound.lostAndFoundType, 'lost_and_found_type', '')}
            </td>
            <td>
                    ${petLostAndFound.lostAndFoundCode}
            </td>
            <td>
                    ${fns:getDictLabel(petLostAndFound.petType, 'pet_type', '')}
            </td>
            <td>
                    ${fns:getDictLabel(petLostAndFound.petGender, 'pet_gender', '')}
            </td>
            <td>
                    ${petLostAndFound.city}
            </td>
            <td>
                    ${petLostAndFound.linkman}
            </td>
            <td>
                    ${petLostAndFound.phone}
            </td>
            <td>
                    ${fns:getDictLabel(petLostAndFound.reviewState, 'lost_and_found_review_state', '')}
            </td>
            <td>
                <c:if test="${petLostAndFound.reviewState==0}">
                    <a href="${ctx}/petLostAndFound/review?id=${petLostAndFound.id}">审核</a>
                </c:if>
            </td>
            <td>
                <a href="${ctx}/petLostAndFound/form?id=${petLostAndFound.id}">查看</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>