package com.cab.passport.marketing.pub.web;

import com.cab.passport.marketing.dao.DogTypeDao;
import com.cab.passport.marketing.entity.DogType;
import com.cab.passport.marketing.entity.RestDogType;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.web.BaseController;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 犬种Controller
 *
 * @author zhangxiang
 * @version 2020-03-11
 */
@Controller
@RequestMapping(value = "/pub/dogtype")
public class DogTypeController extends BaseController {

    @Autowired
    private DogTypeDao dogTypeDao;

    @RequestMapping(value = "", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse getList(HttpServletResponse response) throws IOException {
        List<DogType> result = dogTypeDao.findAllList(new DogType());
        List<RestDogType> list = Lists.newArrayList();
        result.forEach(dogType -> {
            list.add(new RestDogType(dogType));
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list",list);
        return new RESTResponse(jsonObject);
    }
}