package com.cab.passport.petstore.wx;

import com.cab.passport.petstore.wx.service.WeixinService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Lazy(false)
public class WechatTask {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String GET_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="
            + WechatConstant.getConfig("APPID")
            + "&secret="
            + WechatConstant.getConfig("APPSECRET");

    private static final String GET_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";


    @Autowired
    RestTemplate restTemplate;
    @Autowired
    WeixinService wxService;

    //2小时获取一次TICKET
//    @Scheduled(fixedDelay = 1000 * 60 * 60 * 2)
    public void getTicketTask() {
        //获取access_token
        String body = restTemplate.getForEntity(GET_TOKEN_URL, String.class).getBody();
        JSONObject jsonObject = JSONObject.fromObject(body);
        if (!jsonObject.containsKey("access_token")) {
            logger.warn("获取access_token失败:" + body);
            return;
        }
        String accessToken = jsonObject.getString("access_token");
        logger.warn("获取ACCESSTOKEN成功,accessToken=" + accessToken);
        //自定义菜单,启动时执行一次
        createMenu(accessToken);
        //获取ticket
        body = restTemplate.getForEntity(GET_TICKET_URL + accessToken, String.class).getBody();
        jsonObject = JSONObject.fromObject(body);
        if (!jsonObject.containsKey("ticket")) {
            logger.warn("获取ticket失败" + body);
            return;
        }
        String ticket = jsonObject.getString("ticket");
        logger.warn("获取TICKET成功");
        //放入缓存
        WechatConstant.putConfig("ACCESSTOKEN", accessToken);
        WechatConstant.putConfig("TICKET", ticket);
        WxMpInMemoryConfigStorage config = (WxMpInMemoryConfigStorage) wxService.getWxMpConfigStorage();
        config.setAccessToken(accessToken);
        config.setJsapiTicket(ticket);
    }

    //自定义菜单,启动时执行一次
    private void createMenu(String accessToken) {
        if (StringUtils.isBlank(WechatConstant.getConfig("ACCESSTOKEN"))) {
            logger.warn("自定义菜单开始");
            JSONObject jo = new JSONObject();
            JSONArray button = new JSONArray();
            JSONObject button11 = new JSONObject();
            button11.put("type", "view");
            button11.put("name", "浏览宠集盒");
            button11.put("url", "https://open.weixin.qq.com/connect/oauth2/authorize?appid="
                    + WechatConstant.getConfig("APPID")
                    + "&redirect_uri=http%3A%2F%2F"
                    + WechatConstant.getConfig("DOMAIN")
                    + "%2F%3FpetStoreId%3D240%23%2FcabPassList%2F0&response_type=code&scope=snsapi_base&state=#wechat_redirect");
            JSONObject button12 = new JSONObject();
            button12.put("type", "view");
            button12.put("name", "我的宠集盒");
            button12.put("url", "https://open.weixin.qq.com/connect/oauth2/authorize?appid="
                    + WechatConstant.getConfig("APPID")
                    + "&redirect_uri=http%3A%2F%2F"
                    + WechatConstant.getConfig("DOMAIN")
                    + "%2F%23%2Finvite%2F0&response_type=code&scope=snsapi_base&state=#wechat_redirect");
            JSONArray subButton1 = new JSONArray();
            subButton1.add(button11);
            subButton1.add(button12);
            JSONObject button1 = new JSONObject();
            button1.put("name", "查看平台");
            button1.put("sub_button", subButton1);
            JSONObject button2 = new JSONObject();
            button2.put("type", "view");
            button2.put("name", "如何申请");
            button2.put("url", "https://mp.weixin.qq.com/s/XGWQM94z9Gm4N5ePdOno_w");
            button.add(button1);
            button.add(button2);
            jo.put("button", button);
            logger.warn(jo.toString());
            String body = restTemplate.postForEntity("https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken, jo, String.class).getBody();
            JSONObject jsonObject = JSONObject.fromObject(body);
            if (jsonObject.containsKey("errcode") && jsonObject.getInt("errcode") == 0) {
                logger.warn("自定义菜单成功");
            } else {
                logger.warn("自定义菜单失败:" + body);
            }
        }
    }

}
