/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.embedchipclub.service;

import com.cab.passport.embedchipclub.dao.EmbedChipClubDao;
import com.cab.passport.embedchipclub.entity.EmbedChipClub;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.PageBeanResult;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 埋置芯片俱乐部Service
 *
 * @author lgl
 * @version 2018-10-31
 */
@Service
@Transactional(readOnly = true)
public class EmbedChipClubService extends CrudService<EmbedChipClubDao, EmbedChipClub> {

    public EmbedChipClub get(String id) {
        return super.get(id);
    }

    public List<EmbedChipClub> findList(EmbedChipClub embedChipClub) {
        return super.findList(embedChipClub);
    }

    public Page<EmbedChipClub> findPage(Page<EmbedChipClub> page, EmbedChipClub embedChipClub) {
        return super.findPage(page, embedChipClub);
    }

    @Transactional(readOnly = false)
    public void save(EmbedChipClub embedChipClub) {
        super.save(embedChipClub);
    }

    @Transactional(readOnly = false)
    public void delete(EmbedChipClub embedChipClub) {
        super.delete(embedChipClub);
    }

    public RESTResponse getList(HttpServletRequest request) {
        String pageSize = request.getParameter("pageSize");
        String pageNo = request.getParameter("pageNo");
        String city = request.getParameter("city");
        int pageSizeInt = 10;
        int pageNoInt = 1;
        try {
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
        } catch (Exception e) {
            throw new ZAException("pageSize和pageNo必须为数字！");
        }
        EmbedChipClub embedChipClub = new EmbedChipClub();
        if (StringUtils.isNotBlank(city)) {
            embedChipClub.setCity(city);
        }
        Page<EmbedChipClub> page = findPage(new Page<EmbedChipClub>(pageNoInt, pageSizeInt), embedChipClub);
        List<JSONObject> list = new ArrayList<JSONObject>();
        for (EmbedChipClub po : page.getList()) {
            list.add(buildJo(po));
        }
        return new RESTResponse("list", new PageBeanResult<JSONObject>(list, page.getCount()));
    }

    private JSONObject buildJo(EmbedChipClub po) {
        JSONObject data = new JSONObject();
        data.put("name", po.getName());
        data.put("linkman", po.getLinkman());
        data.put("phone", po.getPhone());
        data.put("city", po.getCity());
        data.put("address", po.getAddress());
        return data;
    }
}