/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petstore.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cab.passport.petstore.dao.PetStoreDao;
import com.cab.passport.petstore.entity.PetStore;
import com.cab.passport.petstore.util.ChongaibaoClientUtil;
import com.google.gson.JsonObject;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.ZAException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.ExecutorService;

/**
 * 宠物店Service
 *
 * @author lgl
 * @version 2018-12-18
 */
@Service
@Transactional(readOnly = true)
public class DogActivationService extends CrudService<PetStoreDao, PetStore> {

    private static final String URL = Global.getConfig("CKUOA_URL") + "/oa-web/api/v1/open/breeder/dogActivation/search?";
    private static final String URLCAT = Global.getConfig("CKUOA_CATURL") + "/api/public/v1/cat/outerCatActivation/activationSearch?";
    public static final String PET_STORE_ID = "petStoreId";
    public static final String DOG_IDENTIFICATION_FLAG = "dogIdentificationFlag";
    public static final String CACHE_NAME = "dogActivationCache";

    @Autowired
    RestTemplate restTemplate;
    @Autowired
    ExecutorService petStoreVisitLogQueueThreadPool;

    public String search(HttpServletRequest request) {
        String wxOpenId = (String) request.getSession().getAttribute(PetStoreService.WX_OPEN_ID);
        if (StringUtils.isBlank(wxOpenId)) {
            wxOpenId = "";
        }
        String petStoreId = request.getParameter(PET_STORE_ID);
        String petType=request.getParameter("petType");
        PetStore petStore = (PetStore) request.getSession().getAttribute(PetStoreService.PET_STORE);
        if (petStore != null) {
            petStoreId = petStore.getId();
        } else {
            petStore = dao.get(petStoreId);
        }
        if (petStore == null) {
            throw new ZAException("店铺信息有误");
        }
        //店铺未激活，提示
        if (petStore.getActivationTime() == null) {
            throw new ZAException("该店铺未激活");
        }
        String pageResult=pageRquest(request,request.getParameter("pageSize"),petStore);
        JSONObject jo = JSONObject.parseObject(pageResult);
        jo.put("petStoreName", petStore.getPetStoreName());
        jo.put("pageNo", request.getParameter("pageNo"));
        //线程异步写日志
        addLog("1", wxOpenId, petStoreId, "");
        return jo.toJSONString();
    }
    public  String pageRquest(HttpServletRequest request,String size, PetStore petStore){
        String parmCat= getParameterPage(request.getParameter("pageNo"),size, request.getParameter("breed"),request.getParameter("identificationFlag"),
                request.getParameter("gender"),request.getParameter("age"),request.getParameter("order"), request.getParameter("priceMin"),
                request.getParameter("priceMax"),request.getParameter("consign"),request.getParameter("petType"),petStore);
        logger.warn("分页传参:"+parmCat);
        String result = restTemplate.getForEntity(URLCAT + parmCat, String.class).getBody();
        logger.warn("分页回参:"+result);
        return result;
    }


    public String details(HttpServletRequest request) {
        String wxOpenId = (String) request.getSession().getAttribute(PetStoreService.WX_OPEN_ID);
        if (StringUtils.isBlank(wxOpenId)) {
            wxOpenId = "";
        }
        String petStoreId = request.getParameter(PET_STORE_ID);
        PetStore petStore = (PetStore) request.getSession().getAttribute(PetStoreService.PET_STORE);
        if (petStore != null) {
            petStoreId = petStore.getId();
        } else {
            petStore = dao.get(petStoreId);
        }
        String dogIdentificationFlag = request.getParameter(DOG_IDENTIFICATION_FLAG);
        String petType=request.getParameter("pet_type");
        JSONObject params = new JSONObject();
        params.put("identificationFlag", dogIdentificationFlag);
        params.put("pet_type",petType);
        long t1= System.currentTimeMillis();
        logger.warn("调用pm4入参："+ JSON.toJSONString(params));
        String result = ChongaibaoClientUtil.getPm4(params);
        long t2= System.currentTimeMillis();
        logger.warn("用时："+(t2-t1)/1000);
        logger.warn("调用pm4返回值"+result);
        JSONObject jo = JSONObject.parseObject(result);
        if(StringUtils.isNotBlank(result)){
            if(null!=jo&&null!=petType&&petType.equals("2")){
                if(jo.getString("rc")!=null&&jo.getString("rc").equals("0")) {
                    //去掉卖家联系方式
                    JSONObject data = jo.getJSONObject("data");
                    JSONObject catBasicInfo = data.getJSONObject("catBasicInfo");
                    String mobile = catBasicInfo.getString("mobile");
                    CacheUtils.put(CACHE_NAME, dogIdentificationFlag, mobile);
                    catBasicInfo.put("mobile", "");
                    logger.warn("调用猫的是否寄售：传参："+URLCAT+ getCatParameter(request, petStore));
                    String body = restTemplate.getForEntity(URLCAT + getCatParameter(request, petStore), String.class).getBody();
                    logger.warn("调用猫的是否寄售,返回的参数:"+body);
                    JSONObject jsonObject = JSONObject.parseObject(body);
                    JSONArray jsonArray = jsonObject.getJSONArray("list");
                    if(jsonArray != null && jsonArray.size() > 0){
                        JSONObject jo1 = jsonArray.getJSONObject(0);
                        String consign = jo1.get("consign").toString();
                        catBasicInfo.put("consign", consign);
                    }else{
                        catBasicInfo.put("consign", "0");
                    }
                    //添加商家联系方式
                    JSONObject petStoreInfo = new JSONObject();
                    petStoreInfo.put("petStoreName", petStore.getPetStoreName());
                    petStoreInfo.put("petStoreMobile", petStore.getPetStoreMobile());
                    petStoreInfo.put("identificationFlag", dogIdentificationFlag.substring(dogIdentificationFlag.length() - 6));
                    data.put("petStoreInfo", petStoreInfo);
                }
            }else{
                if(null!=jo&&jo.getString("rc")!=null&&jo.getString("rc").equals("0")) {
                    //去掉卖家联系方式
                    JSONObject data = jo.getJSONObject("data");
                    JSONObject dogBasicInfo = data.getJSONObject("dogBasicInfo");
                    String mobile = dogBasicInfo.getString("mobile");
                    CacheUtils.put(CACHE_NAME, dogIdentificationFlag, mobile);
                    dogBasicInfo.put("mobile", "");
                    //添加是否寄售信息
                    String body = restTemplate.getForEntity(URL + getParameter(request, petStore), String.class).getBody();
                    JSONObject jsonObject = JSONObject.parseObject(body);
                    JSONArray jsonArray = jsonObject.getJSONArray("list");
                    if (jsonArray != null && jsonArray.size() > 0) {
                        JSONObject jo1 = jsonArray.getJSONObject(0);
                        String consign = jo1.get("consign").toString();
                        dogBasicInfo.put("consign", consign);
                    } else {
                        dogBasicInfo.put("consign", "0");
                        //添加商家联系方式
                    }
                    JSONObject petStoreInfo = new JSONObject();
                    petStoreInfo.put("petStoreName", petStore.getPetStoreName());
                    petStoreInfo.put("petStoreMobile", petStore.getPetStoreMobile());
                    petStoreInfo.put("identificationFlag", dogIdentificationFlag.substring(dogIdentificationFlag.length() - 6));
                    data.put("petStoreInfo", petStoreInfo);
                }
            }
            logger.warn("返回前端信息"+jo.toJSONString());
            //线程异步写日志
            addLog("2", wxOpenId, petStoreId, dogIdentificationFlag);
            return jo.toJSONString();
        }else{
            //线程异步写日志
            addLog("2", wxOpenId, petStoreId, dogIdentificationFlag);
            return "";
        }




    }

    public String getPetStoreContact(HttpServletRequest request) {
        String wxOpenId = getWxOpenId(request);
        String petStoreId = request.getParameter(PET_STORE_ID);
        PetStore petStore = (PetStore) request.getSession().getAttribute(PetStoreService.PET_STORE);
        if (petStore != null) {
            petStoreId = petStore.getId();
        }

        String dogIdentificationFlag = request.getParameter(DOG_IDENTIFICATION_FLAG);
        //线程异步写日志
        addLog("3", wxOpenId, petStoreId, dogIdentificationFlag);
        return "";
    }

    public String getPetOwnerContact(HttpServletRequest request) {
        String wxOpenId = (String) request.getSession().getAttribute(PetStoreService.WX_OPEN_ID);
        if (StringUtils.isBlank(wxOpenId)) {
            wxOpenId = "";
        }
        String petStoreId = request.getParameter(PET_STORE_ID);
        PetStore petStore = (PetStore) request.getSession().getAttribute(PetStoreService.PET_STORE);
        if (petStore != null) {
            petStoreId = petStore.getId();
        }
        String dogIdentificationFlag = request.getParameter(DOG_IDENTIFICATION_FLAG);
        String mobile = (String) CacheUtils.get(CACHE_NAME, dogIdentificationFlag);
        if (StringUtils.isBlank(mobile)) {
            mobile = "";
        }
        //线程异步写日志
        logger.warn("返回获取联系人："+mobile);
        addLog("4", wxOpenId, petStoreId, dogIdentificationFlag);
        return mobile;
    }

    //线程异步写日志
    public void addLog(String requestUri, String wxOpenId, String petStoreId, String dogIdentificationFlag) {
        petStoreVisitLogQueueThreadPool.execute(() -> dao.addPetStoreVisitLog(requestUri, wxOpenId, petStoreId, dogIdentificationFlag));
    }

    private String getWxOpenId(HttpServletRequest request) {
        String wxOpenId = (String) request.getSession().getAttribute(PetStoreService.WX_OPEN_ID);
        if (StringUtils.isBlank(wxOpenId)) {
            throw new ZAException("请从新登录");
        }
        return wxOpenId;
    }
    private String getParameterPage(String pageNo,String pageSize,String breed,String identificationFlag,
                                       String gender,String age,String order,String priceMin,String priceMax,String consign,String petType,PetStore petStore) {
        String parentIdArray = "";
        String nameArray = "";
        if (StringUtils.isNotBlank(petStore.getProvinceIds())) {
            JSONObject jo = JSONObject.parseObject(petStore.getProvinceIds());
            parentIdArray = jo.getString("parentIdArray");
            nameArray = jo.getString("nameArray");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parentIdArray=");
        sb.append(parentIdArray);
        sb.append("&nameArray=");
        sb.append(nameArray);
        if (StringUtils.isNotBlank(pageNo)) {
            sb.append("&pageNo=");
            sb.append(pageNo);
        }
        if (StringUtils.isNotBlank(pageSize)) {
            sb.append("&pageSize=");
            sb.append(pageSize);
        }
        if (StringUtils.isNotBlank(breed)) {
            sb.append("&breed=");
            sb.append(breed);
        }
        if (StringUtils.isNotBlank(gender)) {
            sb.append("&gender=");
            sb.append(gender);
        }
        if (StringUtils.isNotBlank(age)) {
            sb.append("&age=");
            sb.append(age);
        }
        if (StringUtils.isNotBlank(order)) {
            sb.append("&order=");
            sb.append(order);
        }
        if (StringUtils.isNotBlank(identificationFlag)) {
            sb.append("&identificationFlag=");
            sb.append(identificationFlag);
        }
        if (StringUtils.isNumeric(priceMin)) {
            sb.append("&priceMin=");
            sb.append(priceMin);
        }
        if (StringUtils.isNumeric(priceMax)) {
            sb.append("&priceMax=");
            sb.append(priceMax);
        }
        if (StringUtils.isNotBlank(consign)) {
            sb.append("&consign=");
            sb.append(consign);
        }
        if(StringUtils.isNotBlank(petType)){
            sb.append("&petType=");
            sb.append(petType);
        }
        return sb.toString();
    }

    private String getCatParameter(HttpServletRequest request, PetStore petStore) {
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        String dogBreed = request.getParameter("catBreed");
        String identificationFlag = request.getParameter("identificationFlag");
        if(StringUtils.isBlank(identificationFlag)){
            identificationFlag = request.getParameter(DOG_IDENTIFICATION_FLAG);
        }
        String gender = request.getParameter("gender");
        String age = request.getParameter("age");
        String order = request.getParameter("order");
        String priceMin = request.getParameter("priceMin");
        String priceMax = request.getParameter("priceMax");
        String consign= request.getParameter("consign");
        String parentIdArray = "";
        String nameArray = "";
        if (StringUtils.isNotBlank(petStore.getProvinceIds())) {
            JSONObject jo = JSONObject.parseObject(petStore.getProvinceIds());
            parentIdArray = jo.getString("parentIdArray");
            nameArray = jo.getString("nameArray");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parentIdArray=");
        sb.append(parentIdArray);
        sb.append("&nameArray=");
        sb.append(nameArray);
        if (StringUtils.isNotBlank(pageNo)) {
            sb.append("&pageNo=");
            sb.append(pageNo);
        }
        if (StringUtils.isNotBlank(pageSize)) {
            sb.append("&pageSize=");
            sb.append(pageSize);
        }
        if (StringUtils.isNotBlank(dogBreed)) {
            sb.append("&dogBreed=");
            sb.append(dogBreed);
        }
        if (StringUtils.isNotBlank(gender)) {
            sb.append("&gender=");
            sb.append(gender);
        }
        if (StringUtils.isNotBlank(age)) {
            sb.append("&age=");
            sb.append(age);
        }
        if (StringUtils.isNotBlank(order)) {
            sb.append("&order=");
            sb.append(order);
        }
        if (StringUtils.isNotBlank(identificationFlag)) {
            sb.append("&identificationFlag=");
            sb.append(identificationFlag);
        }
        if (StringUtils.isNumeric(priceMin)) {
            sb.append("&priceMin=");
            sb.append(priceMin);
        }
        if (StringUtils.isNumeric(priceMax)) {
            sb.append("&priceMax=");
            sb.append(priceMax);
        }
        if (StringUtils.isNotBlank(consign)) {
            sb.append("&consign=");
            sb.append(consign);
        }
        return sb.toString();
    }
    private String getParameterDogPage(String pageNo,String pageSize,String breed,String identificationFlag,
                                       String gender,String age,String order,String priceMin,String priceMax,String consign,PetStore petStore) {
        String parentIdArray = "";
        String nameArray = "";
        if (StringUtils.isNotBlank(petStore.getProvinceIds())) {
            JSONObject jo = JSONObject.parseObject(petStore.getProvinceIds());
            parentIdArray = jo.getString("parentIdArray");
            nameArray = jo.getString("nameArray");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parentIdArray=");
        sb.append(parentIdArray);
        sb.append("&nameArray=");
        sb.append(nameArray);
        if (StringUtils.isNotBlank(pageNo)) {
            sb.append("&pageNo=");
            sb.append(pageNo);
        }
        if (StringUtils.isNotBlank(pageSize)) {
            sb.append("&pageSize=");
            sb.append(pageSize);
        }
        if (StringUtils.isNotBlank(breed)) {
            sb.append("&dogBreed=");
            sb.append(breed);
        }
        if (StringUtils.isNotBlank(gender)) {
            sb.append("&gender=");
            sb.append(gender);
        }
        if (StringUtils.isNotBlank(age)) {
            sb.append("&age=");
            sb.append(age);
        }
        if (StringUtils.isNotBlank(order)) {
            sb.append("&order=");
            sb.append(order);
        }
        if (StringUtils.isNotBlank(identificationFlag)) {
            sb.append("&identificationFlag=");
            sb.append(identificationFlag);
        }
        if (StringUtils.isNumeric(priceMin)) {
            sb.append("&priceMin=");
            sb.append(priceMin);
        }
        if (StringUtils.isNumeric(priceMax)) {
            sb.append("&priceMax=");
            sb.append(priceMax);
        }
        if (StringUtils.isNotBlank(consign)) {
            sb.append("&consign=");
            sb.append(consign);
        }
        return sb.toString();
    }
    private String getParameter(HttpServletRequest request, PetStore petStore) {
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        String dogBreed = request.getParameter("dogBreed");
        String identificationFlag = request.getParameter("identificationFlag");
        if(StringUtils.isBlank(identificationFlag)){
            identificationFlag = request.getParameter(DOG_IDENTIFICATION_FLAG);
        }
        String gender = request.getParameter("gender");
        String age = request.getParameter("age");
        String order = request.getParameter("order");
        String priceMin = request.getParameter("priceMin");
        String priceMax = request.getParameter("priceMax");
        String consign= request.getParameter("consign");
        String parentIdArray = "";
        String nameArray = "";
        if (StringUtils.isNotBlank(petStore.getProvinceIds())) {
            JSONObject jo = JSONObject.parseObject(petStore.getProvinceIds());
            parentIdArray = jo.getString("parentIdArray");
            nameArray = jo.getString("nameArray");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parentIdArray=");
        sb.append(parentIdArray);
        sb.append("&nameArray=");
        sb.append(nameArray);
        if (StringUtils.isNotBlank(pageNo)) {
            sb.append("&pageNo=");
            sb.append(pageNo);
        }
        if (StringUtils.isNotBlank(pageSize)) {
            sb.append("&pageSize=");
            sb.append(pageSize);
        }
        if (StringUtils.isNotBlank(dogBreed)) {
            sb.append("&dogBreed=");
            sb.append(dogBreed);
        }
        if (StringUtils.isNotBlank(gender)) {
            sb.append("&gender=");
            sb.append(gender);
        }
        if (StringUtils.isNotBlank(age)) {
            sb.append("&age=");
            sb.append(age);
        }
        if (StringUtils.isNotBlank(order)) {
            sb.append("&order=");
            sb.append(order);
        }
        if (StringUtils.isNotBlank(identificationFlag)) {
            sb.append("&identificationFlag=");
            sb.append(identificationFlag);
        }
        if (StringUtils.isNumeric(priceMin)) {
            sb.append("&priceMin=");
            sb.append(priceMin);
        }
        if (StringUtils.isNumeric(priceMax)) {
            sb.append("&priceMax=");
            sb.append(priceMax);
        }
        if (StringUtils.isNotBlank(consign)) {
            sb.append("&consign=");
            sb.append(consign);
        }
        return sb.toString();
    }
}