/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.web;

import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.service.PassportOrderPingYangService;
import com.cab.passport.passportorder.service.PassportOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 护照订单Controller
 *
 * @author lgl
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "${adminPath}/passportOrder/pingYang")
public class PassportOrderPingYangController extends BaseController {

    @Autowired
    private PassportOrderService passportOrderService;
    @Autowired
    private PassportOrderPingYangService passportOrderPingYangService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/passportOrder/pingYang/?repage";

    private static final String AUTHORITY_PRDFIX = "passportOrder:pingYang:";

    @ModelAttribute
    public PassportOrder get(@RequestParam(required = false) String id) {
        PassportOrder entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = passportOrderService.get(id);
        }
        if (entity == null) {
            entity = new PassportOrder();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(PassportOrder passportOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<PassportOrder> page = passportOrderService.findPage(new Page<PassportOrder>(request, response), passportOrder);
        model.addAttribute("page", page);
        return "passportOrder/passportOrderPingYangList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(PassportOrder passportOrder, Model model) {
        model.addAttribute("passportOrder", passportOrder);
        return "passportOrder/passportOrderPingYangForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "edit")
    public String edit(PassportOrder passportOrder, Model model, RedirectAttributes redirectAttributes) {
        passportOrderPingYangService.edit(passportOrder);
        addMessage(redirectAttributes, "保存护照订单成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "print")
    public String print(PassportOrder passportOrder, Model model) {
        passportOrderPingYangService.print(passportOrder);
        model.addAttribute("passportOrder", passportOrder);
        return "passportOrder/passportOrderPingYangPrint";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "resetPrint")
    public String resetPrint(PassportOrder passportOrder, RedirectAttributes redirectAttributes) {
        passportOrderPingYangService.resetPrint(passportOrder);
        addMessage(redirectAttributes, "重置成功");
        return REPAGE;
    }
    @RequestMapping(value = "exportExcel")
    public void exportExcel(HttpServletRequest request,HttpServletResponse response,RedirectAttributes redirectAttributes,PassportOrder passportOrder) {
        String ids = request.getParameter("ids");
        try {
           passportOrderPingYangService.exportExcel(ids,passportOrder,response);
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
        }
    }
}