/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.embedchipclub.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * 埋置芯片俱乐部Entity
 *
 * @author lgl
 * @version 2018-10-31
 */
public class EmbedChipClub extends DataEntity<EmbedChipClub> {

    private static final long serialVersionUID = 1L;
    private String name;        // 俱乐部名称
    private String linkman;        // 联系人
    private String phone;        // 电话
    private String city;        // 城市
    private String address;        // 地址

    public EmbedChipClub() {
        super();
    }

    public EmbedChipClub(String id) {
        super(id);
    }

    @Length(min = 1, max = 50, message = "俱乐部名称长度必须介于 1 和 50 之间")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(min = 1, max = 20, message = "联系人长度必须介于 1 和 20 之间")
    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    @Length(min = 1, max = 20, message = "电话长度必须介于 1 和 20 之间")
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Length(min = 1, max = 20, message = "城市长度必须介于 1 和 20 之间")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Length(min = 1, max = 200, message = "地址长度必须介于 1 和 200 之间")
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

}