/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.tcbpetorder.web;

import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.cab.passport.tcbpetorder.service.TcbPetOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 淘宠宝宠物订单Controller
 *
 * @author lgl
 * @version 2018-11-22
 */
@Controller
@RequestMapping(value = "${adminPath}/tcbPetOrder")
public class TcbPetOrderController extends BaseController {

    @Autowired
    private TcbPetOrderService tcbPetOrderService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/tcbPetOrder/?repage";

    private static final String AUTHORITY_PRDFIX = "tcbPetOrder:";

    @ModelAttribute
    public TcbPetOrder get(@RequestParam(required = false) String id) {
        TcbPetOrder entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = tcbPetOrderService.get(id);
        }
        if (entity == null) {
            entity = new TcbPetOrder();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(TcbPetOrder tcbPetOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<TcbPetOrder> page = tcbPetOrderService.findPage(new Page<TcbPetOrder>(request, response), tcbPetOrder);
        model.addAttribute("page", page);
        return "tcbPetOrder/tcbPetOrderList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "form")
    public String form(TcbPetOrder tcbPetOrder, Model model) {
        model.addAttribute("tcbPetOrder", tcbPetOrder);
        return "tcbPetOrder/tcbPetOrderForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(TcbPetOrder tcbPetOrder, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, tcbPetOrder)) {
            return form(tcbPetOrder, model);
        }
        tcbPetOrder.setRemarks("");
        tcbPetOrderService.save(tcbPetOrder);
        addMessage(redirectAttributes, "保存淘宠宝宠物订单成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(TcbPetOrder tcbPetOrder, RedirectAttributes redirectAttributes) {
        tcbPetOrderService.delete(tcbPetOrder);
        addMessage(redirectAttributes, "删除淘宠宝宠物订单成功");
        return REPAGE;
    }

}