<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>埋置芯片俱乐部管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/embedchipclub/embedChipClub/">埋置芯片俱乐部列表</a></li>
    <shiro:hasPermission name="embedchipclub:embedChipClub:edit">
        <li><a href="${ctx}/embedchipclub/embedChipClub/form">埋置芯片俱乐部添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="embedChipClub" action="${ctx}/embedchipclub/embedChipClub/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>俱乐部名称：</label>
            <form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>联系人：</label>
            <form:input path="linkman" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>电话：</label>
            <form:input path="phone" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>城市：</label>
            <form:input path="city" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>地址：</label>
            <form:input path="address" htmlEscape="false" maxlength="200" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>俱乐部名称</th>
        <th>联系人</th>
        <th>电话</th>
        <th>城市</th>
        <th>地址</th>
        <shiro:hasPermission name="embedchipclub:embedChipClub:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="embedChipClub">
        <tr>
            <td><a href="${ctx}/embedchipclub/embedChipClub/form?id=${embedChipClub.id}">
                    ${embedChipClub.name}
            </a></td>
            <td>
                    ${embedChipClub.linkman}
            </td>
            <td>
                    ${embedChipClub.phone}
            </td>
            <td>
                    ${embedChipClub.city}
            </td>
            <td>
                    ${embedChipClub.address}
            </td>
            <shiro:hasPermission name="embedchipclub:embedChipClub:edit">
                <td>
                    <a href="${ctx}/embedchipclub/embedChipClub/form?id=${embedChipClub.id}">修改</a>
                    <a href="${ctx}/embedchipclub/embedChipClub/delete?id=${embedChipClub.id}"
                       onclick="return confirmx('确认要删除该埋置芯片俱乐部吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>