/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.referrer.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 推荐人Entity
 * @author zfx
 * @version 2019-03-27
 */
public class Referrer extends DataEntity<Referrer> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title = "姓名", align = 2, sort = 0)
	private String name;		// 名字
	@ExcelField(title = "电话", align = 2, sort = 1)
	private String phone;		// 电话
	@ExcelField(title = "推荐人编码", align = 2, sort = 2)
	private String code;		// 推荐人编码
	@ExcelField(title = "备注", align = 2, sort = 3)
	private String mark;		// 备注
	@ExcelField(title = "数量", align = 2, sort = 3)
	private String count;      //数量
	private String status;        //状态
	
	public Referrer() {
		super();
	}

	public Referrer(String id){
		super(id);
	}

	@Length(min=1, max=20, message="名字长度必须介于 1 和 20 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=50, message="电话长度必须介于 0 和 50 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}
	
	@Length(min=1, max=50, message="推荐人编码长度必须介于 1 和 50 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=0, max=200, message="备注长度必须介于 0 和 200 之间")
	public String getMark() {
		return mark;
	}

	public void setMark(String mark) {
		this.mark = mark;
	}

	public String getCount() {
		return count;
	}

	public void setCount(String count) {
		this.count = count;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
}