/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.tcbpetorder.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.cab.passport.common.ResultVo;
import com.cab.passport.common.ResultVoUtil;
import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.cab.passport.tcbpetorder.service.TcbPetOrderService;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 淘宠宝宠物订单Controller
 *
 * @author lgl
 * @version 2018-11-22
 */
@RestController
@RequestMapping(value = "/tcbPetOrder")
public class RestTcbPetOrderController extends BaseController {

    @Autowired
    private TcbPetOrderService tcbPetOrderService;

    @ResponseBody
    @RequestMapping(value = "/validate/{identificationFlag}", method = RequestMethod.GET)
    public ResultVo<Boolean> list(TcbPetOrder tcbPetOrder,HttpServletRequest request, HttpServletResponse response) {
    	List<TcbPetOrder> tcbPetOrderList = tcbPetOrderService.findList(tcbPetOrder);
        return ResultVoUtil.success(!CollectionUtils.isEmpty(tcbPetOrderList));
    }
    
}