/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.service;

import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.entity.PassportOrderBusinessStateEnum;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 护照订单Service
 *
 * @author lgl
 * @version 2018-10-09
 */
@Service
@Transactional(readOnly = true)
public class PassportOrderTmallService extends CrudService<PassportOrderDao, PassportOrder> {

    public PassportOrder get(String id) {
        return super.get(id);
    }

    public List<PassportOrder> findList(PassportOrder passportOrder) {
        return super.findList(passportOrder);
    }

    public Page<PassportOrder> findPage(Page<PassportOrder> page, PassportOrder passportOrder) {
        return super.findPage(page, passportOrder);
    }

    @Transactional(readOnly = false)
    public void edit(PassportOrder passportOrder) {
        super.save(passportOrder);
    }

    @Transactional(readOnly = false)
    public void savePassportOrder(PassportOrder vo) {
        validatePassportOrder(vo);
        PassportOrder passportOrder;
        if (StringUtils.isBlank(vo.getId())) {
            passportOrder = new PassportOrder();
        } else {
            passportOrder = get(vo.getId());
            if (passportOrder == null) {
                throw new RuntimeException("该订单记录不存在！");
            }
            if (!"1".equals(PassportOrderBusinessStateEnum.WAIT_FOR_INPUT_IDENTIFICATIONFLAG.getValue())) {
                throw new RuntimeException("该订单记录不能修改！");
            }
        }
        buildPassportOrder(passportOrder, vo);
        save(passportOrder);
    }

    private void buildPassportOrder(PassportOrder passportOrder, PassportOrder vo) {
        passportOrder.setTmallOrderCode(vo.getTmallOrderCode());
        passportOrder.setPackageType(vo.getPackageType());
        passportOrder.setOrderTime(vo.getOrderTime());
        passportOrder.setWangwangId(vo.getWangwangId());
        passportOrder.setConsigneeAddress(vo.getConsigneeAddress());
        passportOrder.setConsigneeName(vo.getConsigneeName());
        passportOrder.setConsigneePhone(vo.getConsigneePhone());
        passportOrder.setPetBirthday(vo.getPetBirthday());
        passportOrder.setPetName(vo.getPetName());
        passportOrder.setPetType(vo.getPetType());
        passportOrder.setPetBirthday(vo.getPetBirthday());
        passportOrder.setConsigneeProvince(vo.getConsigneeProvince());
        passportOrder.setConsigneeCity(vo.getConsigneeCity());
        passportOrder.setConsigneeDistrict(vo.getConsigneeDistrict());
        passportOrder.setExpressWeight(vo.getExpressWeight());
        passportOrder.setConsigneeLandline(vo.getConsigneeLandline());
        passportOrder.setPetCoatColor(vo.getPetCoatColor());
        passportOrder.setPetGender(vo.getPetGender());
        passportOrder.setBusinessState(PassportOrderBusinessStateEnum.WAIT_FOR_INPUT_IDENTIFICATIONFLAG.getValue());
    }

    private void validatePassportOrder(PassportOrder vo) {
        if (StringUtils.isBlank(vo.getTmallOrderCode())) {
            throw new RuntimeException("天猫订单号不能为空！");
        }
        String packageType = vo.getPackageType();
        if (StringUtils.isBlank(packageType)) {
            throw new RuntimeException("套餐类型不能为空！");
        }
        if (!"1".equals(packageType) && !"2".equals(packageType) && !"3".equals(packageType) && !"4".equals(packageType)) {
            throw new RuntimeException("没有该套餐类型！");
        }
        if (StringUtils.isBlank(vo.getWangwangId())) {
            throw new RuntimeException("旺旺ID不能为空！");
        }
        if (StringUtils.isBlank(vo.getConsigneeAddress())) {
            throw new RuntimeException("收货地址不能为空！");
        }
        if (StringUtils.isBlank(vo.getConsigneeName())) {
            throw new RuntimeException("收货人不能为空！");
        }
        if (StringUtils.isBlank(vo.getConsigneePhone())) {
            throw new RuntimeException("收货人电话不能为空！");
        }
        if (StringUtils.isBlank(vo.getPetName())) {
            throw new RuntimeException("宠物姓名不能为空！");
        }
        String petType = vo.getPetType();
        if (StringUtils.isBlank(petType)) {
            throw new RuntimeException("宠物类型不能为空！");
        }
        if (!"1".equals(petType) && !"2".equals(petType)) {
            throw new RuntimeException("宠物类型只能为狗或猫！");
        }
        String petGender = vo.getPetGender();
        if (StringUtils.isBlank(petGender)) {
            throw new RuntimeException("宠物性别不能为空！");
        }
        if (!"1".equals(petGender) && !"2".equals(petGender)) {
            throw new RuntimeException("宠物性别只能为公或母！");
        }
        if (StringUtils.isBlank(vo.getPetName())) {
            throw new RuntimeException("宠物姓名不能为空！");
        }
        if (StringUtils.isBlank(vo.getPetCoatColor())) {
            throw new RuntimeException("宠物毛色不能为空！");
        }
        if (vo.getPetBirthday() == null) {
            throw new RuntimeException("宠物生日不能为空！");
        }
        if (vo.getOrderTime() == null) {
            throw new RuntimeException("下单时间不能为空！");
        }
    }
}