
package com.thinkgem.jeesite.modules.sys.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 文件模块Entity
 *
 * @author rain
 * @version 2015-12-18
 */
public class BaseFile extends DataEntity<BaseFile> {

    private static final long serialVersionUID = 1L;
    private String orginalname;        // 文件的名称
    private String name;        // 系统标识文件的唯一名称，自动生成,一般不可改变，表示虚拟文件名
    private String type;        // 文件的MIME类型
    private String extension;        // 文件的扩展名
    private Long size;        // 文件的大小
    private String location;        // 文件的物理路径
    private String description;        // 文件的描述
    private String ownerid;        // 文件的归属人
    private String ownername;        // 文件归属人的名称
    private String status;        // 文件的状态，1表示在回收站，0表示不在回收站
    private String openFlag;        // 是否公开标记位。0不公开；1公开

    public BaseFile() {
        super();
    }

    public BaseFile(String id) {
        super(id);
    }

    @Length(min = 1, max = 64, message = "文件的名称长度必须介于 1 和 64 之间")
    public String getOrginalname() {
        return orginalname;
    }

    public void setOrginalname(String orginalname) {
        this.orginalname = orginalname;
    }

    @Length(min = 1, max = 64, message = "系统标识文件的唯一名称，自动生成,一般不可改变，表示虚拟文件名长度必须介于 1 和 64 之间")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(min = 0, max = 64, message = "文件的MIME类型长度必须介于 0 和 64 之间")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Length(min = 1, max = 64, message = "文件的扩展名长度必须介于 1 和 64 之间")
    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @NotNull(message = "文件的大小不能为空")
    public Long getSize() {
        return size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Length(min = 1, max = 64, message = "文件的物理路径长度必须介于 1 和 64 之间")
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Length(min = 1, max = 64, message = "文件的归属人长度必须介于 1 和 64 之间")
    public String getOwnerid() {
        return ownerid;
    }

    public void setOwnerid(String ownerid) {
        this.ownerid = ownerid;
    }

    @Length(min = 0, max = 64, message = "文件归属人的名称长度必须介于 0 和 64 之间")
    public String getOwnername() {
        return ownername;
    }

    public void setOwnername(String ownername) {
        this.ownername = ownername;
    }

    @Length(min = 0, max = 1, message = "文件的状态，1表示在回收站，0表示不在回收站长度必须介于 0 和 1 之间")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOpenFlag() {
        return openFlag;
    }

    public void setOpenFlag(String openFlag) {
        this.openFlag = openFlag;
    }
}