<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>广告管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    if ($("#img").val() == '') {
                        alert("请上传背景图片");
                        return 0;
                    }
                    var url=$("#url").val();
                    if(url.length>0){
                        if(url.substr(0,7).toLowerCase() != "http://"&&url.substr(0,8).toLowerCase() != "https://"){
                            alert("url必须是http://开头或者https");
                            return 0;
                        }
                    }
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //下拉回显
            $("#type").val("${banner.type}");
            $("#type").trigger("change");
            $("#visibleFlag").val("${banner.visibleFlag}");
            $("#visibleFlag").trigger("change");

        });

        function deleteImg() {
            $("#test").attr("src", "");
            $("#thumbnailImage").val("");
        }

    </script>
    <link href="${ctxStatic}/layui/css/layui.css" type="text/css" rel="stylesheet"/>
    <script src="${ctxStatic}/layui/layui.all.js" type="text/javascript"></script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/breeder/banner/">广告列表</a></li>
    <li class="active"><a href="${ctx}/breeder/banner/form?id=${banner.id}">广告<shiro:hasPermission
            name="breeder:banner:edit">${not empty banner.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="breeder:banner:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="banner" action="${ctx}/breeder/banner/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
 <%--   <div class="control-group">
        <label class="control-label">模块：</label>
        <div class="controls">
            <form:input path="module" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>--%>
    <%--<div class="control-group">
        <label class="control-label">标题：</label>
        <div class="controls">
            <form:input path="title" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>--%>
    <div class="control-group">
        <label class="control-label">背景图片：</label>
        <div class="controls">
            <div style="float:left;width:50%;">
                <div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
                    <center><img id="previewCatImg" alt=""
                                 src="${ctx}/pub/file/image/${banner.img}"
                                 style="padding:10px;height:130px;"/></center>
                    <div style="position:relative;color: #cccccc;font-size: 18px;">
                        <center>图片预览</center>
                    </div>
                </div>
            </div>
            <div style="float:right;width:50%;">
                <div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;position:relative;">
                    <button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
                            id="catImgUpload">
                        <i class="layui-icon">&#xe67c;</i>上传图片
                    </button>
                    <form:input path="img" htmlEscape="false" maxlength="255" class="input-xlarge required"
                                type="hidden"/>
                </div>
            </div>
            <script type="text/javascript">
                layui.use('upload', function () {
                    var upload = layui.upload;
                    //执行实例
                    var uploadInst = upload.render({
                        elem: '#catImgUpload' //绑定元素
                        , url: '${ctx}/pub/file/layupload' //上传接口ctx
                        , done: function (res) {//上传完毕回调
                            $("#img").val(res.id);
                            $("#previewCatImg").attr("src", res.url);
                        }
                        , error: function () {
                            //请求异常回调
                        }
                    });
                });
            </script>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">跳转地址：</label>
        <div class="controls">
            <form:textarea path="url" htmlEscape="false" rows="2" maxlength="300" class="input-xxlarge"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">跳转类型：</label>
        <div class="controls">
            <form:select path="type" class="input-medium">
                <option value="0">URL跳转</option>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否可见：</label>
        <div class="controls">
            <form:select path="visibleFlag" class="input-medium">
                <option value="1">可见</option>
                <option value="0">不可见</option>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
   <%-- <div class="control-group">
        <label class="control-label">显示开始时间：</label>
        <div class="controls">
            <input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${banner.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示结束时间：</label>
        <div class="controls">
            <input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${banner.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>--%>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false" type="number" min="0" maxlength="5" class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1024" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="breeder:banner:edit"><input id="btnSubmit" class="btn btn-primary" type="submit"
                                                               value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>