<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#chk_all").click(function(){
                if ($(this).is(":checked")) {
                    $("input[name='chk_list']").attr("checked",$(this).attr("checked"));
                } else {
                    $("input[name='chk_list']").attr("checked",false);
                }

            });
        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").attr("action","${ctx}/passportOrder/pingYang/");
            $("#searchForm").submit();
            return false;
        }
        function  excelAdd() {
            var ids = "";
            $("input[name='chk_list']:checked").each(function() {
                ids += this.value+",";
            });
            if(ids == ''){
                alert("请选择需要导出的地址。");
                return;
            }
            $("#searchForm").attr("action","${ctx}/passportOrder/pingYang/exportExcel?ids="+ids);
            $("#searchForm").submit();
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/passportOrder/pingYang/">护照订单列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="passportOrder" action="${ctx}/passportOrder/pingYang/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>天猫订单号：</label>
            <form:input path="tmallOrderCodeLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>芯片号：</label>
            <form:input path="identificationFlagLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠爱护照号：</label>
            <form:input path="cabPassportLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>手机号：</label>
            <form:input path="consigneePhoneLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>旺旺ID：</label>
            <form:input path="wangwangIdLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>业务状态：</label>
            <form:select path="businessState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('passport_order_business_state')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/></li>
        <li class="btns"><input id="excel_btn" class="btn btn-primary" type="button" value="导出地址" onclick="excelAdd()"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>全选<input type="checkbox" id="chk_all"></th>
        <th>天猫订单号</th>
        <th>姓名</th>
        <th>电话</th>
        <th>购买套餐</th>
        <th>下单时间</th>
        <th>业务状态</th>
        <th>芯片号</th>
        <th>护照号</th>
        <th>快递号</th>
        <th>修改时间</th>
        <shiro:hasPermission name="passportOrder:pingYang:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="passportOrder">
        <tr>
            <td>
                <input type="checkbox" name="chk_list" value="${passportOrder.id}">
            </td>
            <td>
                    ${passportOrder.tmallOrderCode}
            </td>
            <td>
                    ${passportOrder.consigneeName}
            </td>
            <td>
                    ${passportOrder.consigneePhone}
            </td>
            <td>
                    ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm"/>
            </td>
            <td>
                    ${fns:getDictLabel(passportOrder.businessState, 'passport_order_business_state', '')}
            </td>
            <td>
                    ${passportOrder.identificationFlag}
            </td>
            <td>
                    ${passportOrder.cabPassport}
            </td>
            <td>
                    ${passportOrder.expressNumber}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <shiro:hasPermission name="passportOrder:pingYang:edit">
                <td>
                    <c:if test="${passportOrder.businessState==2}">
                        <a href="${ctx}/passportOrder/pingYang/print?id=${passportOrder.id}"
                           onclick="return confirmx('确认要打印该护照吗？', this.href)">打印</a>
                    </c:if>
                    <c:if test="${passportOrder.businessState==3}">
                        <a href="${ctx}/passportOrder/pingYang/resetPrint?id=${passportOrder.id}"
                           onclick="return confirmx('确认要重置打印吗？', this.href)">重置打印</a>
                    </c:if>
                    <c:if test="${passportOrder.businessState==1||passportOrder.businessState==2||passportOrder.businessState==3}">
                        <a href="${ctx}/passportOrder/pingYang/form?id=${passportOrder.id}">编辑</a>
                    </c:if>

                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>