package com.thinkgem.jeesite.common.utils;


import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils
{
	public static boolean isHttps(HttpServletRequest r)
	{
		return true;
	}

	public static void writeResponse(HttpServletResponse response, RESTResponse r) throws IOException
	{
		response.setHeader("Content-type", "application/json;charset=UTF-8");
		response.setHeader("Access-Control-Allow-Origin", "*");
		response.setHeader("Access-Control-Allow-Credentials", "true");
		response.setHeader("Access-Control-Allow-Methods", "POST, GET, PUT, DELETE");
		response.setHeader("Access-Control-Allow-Headers", "Content-Type, Content-Length, Connection, Cache-Control");
		StreamUtils.writeStream(response.getOutputStream(), r);
		
		if (r.getRc() != 0)
		{
			response.setStatus(200);
		}
		response.flushBuffer();
	}
	
	public static String getParameter(HttpServletRequest r, String paramName, String defaultVal)
	{
		String p = r.getParameter(paramName);
		if (p == null) return defaultVal;
		
		return p;
	}



}