package com.cab.passport.petstore.wx.handler;

import com.cab.passport.petstore.wx.builder.ImageBuilder;
import com.cab.passport.petstore.wx.builder.NewsBuilder;
import com.cab.passport.petstore.wx.service.WeixinService;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author Binary Wang
 */
@Component
public class MsgHandler extends AbstractHandler {

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage,
                                    Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) {

        WeixinService weixinService = (WeixinService) wxMpService;

        if (!wxMessage.getMsgType().equals(WxConsts.XmlMsgType.EVENT)) {
            //TODO 可以选择将消息保存到本地
        }

/*        //当用户输入关键词如“你好”，“客服”等，并且有客服在线时，把消息转发给在线客服
        if (StringUtils.startsWithAny(wxMessage.getContent(), "报名")
                && weixinService.hasKefuOnline()) {
            return WxMpXmlOutMessage
                    .TRANSFER_CUSTOMER_SERVICE().fromUser(wxMessage.getToUser())
                    .toUser(wxMessage.getFromUser()).build();
        }*/

        //TODO 组装回复消息
        WxMpXmlOutMessage wxMpXmlOutMessage;
        if (StringUtils.startsWithAny(wxMessage.getContent(), "01") || StringUtils.startsWithAny(wxMessage.getContent(), "1")) {
            wxMpXmlOutMessage = new ImageBuilder().build("YEk-GE-jluDTHev9tktoOI8yN-nJcOQDZ0M4FPXhJOA", wxMessage, weixinService);
        } else if (StringUtils.startsWithAny(wxMessage.getContent(), "02") || StringUtils.startsWithAny(wxMessage.getContent(), "2")) {
            wxMpXmlOutMessage = new NewsBuilder().build("CKU犬舍、CAAC猫舍、个人繁殖怎么使用宠集盒？",
                    "如果你是CKU犬舍、CAAC猫舍或个人繁殖，该怎样使用宠集盒呢？",
                    "http://mmbiz.qpic.cn/mmbiz_png/MDDMFkrkBXG93DSjy576cXTfG78uSkRj8WywMohKrFVBw6ib3YGk5HRFJaCOXJSzlyJgRpvfr98eTllJIXBuQjg/0?wx_fmt=png",
                    "http://mp.weixin.qq.com/s?__biz=MzIwNDIwMjY1MA==&mid=100000335&idx=1&sn=171506c37a6319357ec5c59d6b3396ac&chksm=16c2f5ba21b57cac2aadcf4099719259a088d35c0f291648694fe4fe5ca73c346546e1520003#rd",
                    wxMessage,
                    weixinService);
        } else if (StringUtils.startsWithAny(wxMessage.getContent(), "03") || StringUtils.startsWithAny(wxMessage.getContent(), "3")) {
            wxMpXmlOutMessage = new NewsBuilder().build("宠集盒问答集锦",
                    "宠集盒Q&A",
                    "http://mmbiz.qpic.cn/mmbiz_png/MDDMFkrkBXG93DSjy576cXTfG78uSkRj3dY77iaAliajyNekm1wFY8IqKHgECDxwe4WhDkrxmEMfGRcyZYOialbqw/0?wx_fmt=png",
                    "http://mp.weixin.qq.com/s?__biz=MzIwNDIwMjY1MA==&mid=100000338&idx=1&sn=5e13f5687a9647858f6cff21c78a4947&chksm=16c2f5a721b57cb19c0c1ddc014192171ea3be30a393af0109cebeba12561a8dbe7ba7a2f250#rd",
                    wxMessage,
                    weixinService);
        } else {
            wxMpXmlOutMessage = new ImageBuilder().build("YEk-GE-jluDTHev9tktoOGJt7-HSe1lmGeM0ck3xSPk", wxMessage, weixinService);
        }
        return wxMpXmlOutMessage;
    }

}
