package com.cab.passport.petstore.wx;

import com.cab.passport.petstore.dao.PetStoreDao;
import com.cab.passport.petstore.entity.PetStore;
import com.cab.passport.petstore.service.PetStoreService;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.UUID;

@Controller
@RequestMapping(value = "pub/petStore/wx")
public class WechatController {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

//    private static final String TOKEN = WechatConstant.getConfig("TOKEN");

    private static final String APPID = WechatConstant.getConfig("APPID");

    private static final String URL = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code&appid="
            + APPID
            + "&secret=" + WechatConstant.getConfig("APPSECRET")
            + "&code=";

    @Autowired
    RestTemplate restTemplate;
    @Autowired
    PetStoreDao petStoreDao;

    @RequestMapping(value = "/login", method = RequestMethod.GET)
    @ResponseBody
    public JSONObject login(HttpServletRequest request) {
        String code = request.getParameter("code");
        logger.warn("前端传的code"+code);
        String body = restTemplate.getForEntity(URL + code, String.class).getBody();
        JSONObject jsonObject = JSONObject.fromObject(body);
        if (!jsonObject.containsKey("openid")) {
            logger.info("获取openId失败");
            return jsonObject;
        }
        //缓存wxOpenId
        String wxOpenId = jsonObject.getString("openid");
        request.getSession().setAttribute(PetStoreService.WX_OPEN_ID, wxOpenId);
        //宠物店id，根据该字段是否为空判断是否是宠物店
        String petStoreId = "";
        PetStore petStore = petStoreDao.getByWxOpenId(jsonObject.getString("openid"));
        if (petStore != null) {
            petStoreId = petStore.getId();
            //缓存店铺实体
            request.getSession().setAttribute(PetStoreService.PET_STORE, petStore);
        }
        jsonObject.clear();
        jsonObject.put("petStoreId", petStoreId);
        logger.warn("返回"+jsonObject.toString());
        return jsonObject;
    }

//    @RequestMapping(value = "/checkToken", method = RequestMethod.GET)
//    @ResponseBody
//    public String checkToken(HttpServletRequest request) {
//        String signature = request.getParameter("signature");
//        String timestamp = request.getParameter("timestamp");
//        String nonce = request.getParameter("nonce");
//        String echostr = request.getParameter("echostr");
//        logger.info("接收到来自微信服务器的认证消息：[{}, {}, {}, {}]", signature, timestamp, nonce, echostr);
//        if (StringUtils.isAnyBlank(signature, timestamp, nonce, echostr)) {
//            throw new IllegalArgumentException("请求参数非法，请核实!");
//        }
//        if (checkSignature(timestamp, nonce, signature)) {
//            return echostr;
//        }
//        return "非法请求";
//    }

    @RequestMapping(value = "/signature", method = RequestMethod.GET)
    @ResponseBody
    public JSONObject signature(HttpServletRequest request) {
        String url = request.getParameter("url");
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("请求参数非法，请核实!");
        }
        logger.warn("url:___________________________"+url);
        String jsapiTicket = WechatConstant.getConfig("TICKET");
        String nonceStr = UUID.randomUUID().toString();
        String timestamp = Long.toString(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder("jsapi_ticket=");
        sb.append(jsapiTicket);
        sb.append("&noncestr=");
        sb.append(nonceStr);
        sb.append("&timestamp=");
        sb.append(timestamp);
        sb.append("&url=");
        sb.append(url);
        JSONObject data = new JSONObject();
        data.put("appId", APPID);
        data.put("timestamp", timestamp);
        data.put("nonceStr", nonceStr);
        data.put("signature", DigestUtils.sha1Hex(sb.toString()));
        logger.warn("返回值"+data.toString());
        return data;
    }

//    public boolean checkSignature(String timestamp, String nonce, String signature) {
//        try {
//            return gen(new String[]{TOKEN, timestamp, nonce}).equals(signature);
//        } catch (Exception var5) {
//            logger.error("Checking signature failed, and the reason is :" + var5.getMessage());
//            return false;
//        }
//    }

//    private String gen(String... arr) {
//        if (StringUtils.isAnyEmpty(arr)) {
//            throw new IllegalArgumentException("非法请求参数，有部分参数为空 : " + Arrays.toString(arr));
//        } else {
//            Arrays.sort(arr);
//            StringBuilder sb = new StringBuilder();
//            String[] var2 = arr;
//            int var3 = arr.length;
//            for (int var4 = 0; var4 < var3; ++var4) {
//                String a = var2[var4];
//                sb.append(a);
//            }
//            return DigestUtils.sha1Hex(sb.toString());
//        }
//    }

}
