/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.dao;

import com.cab.passport.sys.payment.entity.PaymentOrderDetail;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 * 订单详细DAO接口
 *
 * @author lyy
 * @version 2016-08-04
 */
@MyBatisDao
public interface PaymentOrderDetailDao extends CrudDao<PaymentOrderDetail> {
	int updateProccessState(PaymentOrderDetail paymentOrderDetail);

	// 美容 培训 校验在线申领的订单
	List<PaymentOrderDetail> getOrderByRunningNum(@Param("orderCode") String orderCode);

	List<PaymentOrderDetail> statistical(@Param("projectId") String projectId);

	// 美容 培训 校验在线申领的订单
	List<PaymentOrderDetail> validOrder(PaymentOrderDetail paymentOrderDetail);

	PaymentOrderDetail getByOrderCode(String id);

	List<PaymentOrderDetail> findByOrderCode(@Param("orderCode") String orderCode);

	/**
	 * 获取全部（包含已删除）
	 *
	 * @param orderCode
	 * @return
	 */
	List<PaymentOrderDetail> findAllByOrderCode(@Param("orderCode") String orderCode);

	List<PaymentOrderDetail> findByOrderCodeAndItemId(@Param("orderCode") String orderCode,
                                                      @Param("itemId") String itemId);

	/**
	 * 通过收费项查询指定范围内的付款记录
	 *
	 * @param chargeItemId
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	List<PaymentOrderDetail> findDetailByChargeItem(@Param("chargeItemId") String chargeItemId,
                                                    @Param("startDate") String startDate, @Param("endDate") String endDate);

	HashMap findDetailByChargeItemCount(@Param("chargeItemId") String chargeItemId,
                                        @Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 * 查询需要拆分调整的数据合集
	 *
	 * @param detail
	 * @return
	 */
	List<PaymentOrderDetail> findAdjustmentList(PaymentOrderDetail detail);

	Integer getUsedDetail(@Param("tableName") String tableName, @Param("orderCode") String orderCode);

	void updateBusinessRefundState(PaymentOrderDetail vo);

	List<PaymentOrderDetail> getByBusiness(PaymentOrderDetail vo);

	void updateRefundStateByParam(PaymentOrderDetail vo);

	List<PaymentOrderDetail> getByBusinessIds(@Param("ids") Set<String> ids);

	List<PaymentOrderDetail> findUnpaidDetail(@Param("memberCode") String memberCode);
}