package com.cab.passport.petstore.wx.handler;

import com.cab.passport.petstore.wx.builder.TextBuilder;
import com.cab.passport.petstore.wx.service.WeixinService;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author Binary Wang
 */
@Component
public class SubscribeHandler extends AbstractHandler {

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {

        this.logger.info("新关注用户 OPENID: " + wxMessage.getFromUser());

        WeixinService weixinService = (WeixinService) wxMpService;

        // 获取微信用户基本信息
        WxMpUser userWxInfo = weixinService.getUserService().userInfo(wxMessage.getFromUser(), null);

        if (userWxInfo != null) {
            // TODO 可以添加关注用户到本地
        }

        WxMpXmlOutMessage responseResult = null;
        try {
            responseResult = handleSpecial(wxMessage);
        } catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }

        if (responseResult != null) {
            return responseResult;
        }

        try {
        	// commit test
        	return new TextBuilder().build("感谢您关注宠爱王国——中国宠物行业标准与专业内容的输出者。\n" + 
    				"\n" + 
    			    "无论您是宠业人，还是宠物爱好者，\n" + 
    				"行业相关的问题，都能在宠爱王国找到答案。\n" +
    			    "\n" + 
    				"宠爱王国客服电话:\n" + 
    			    "4006607000\n" +
    				"\n" +
    			    "投诉邮箱:\n" +
    				"tousu@chongaibao.com\n" +
    				"\n" + 
    				"内控邮箱:\n" + 
    				"tousujianyi@chongaibao.com",
    			    wxMessage, weixinService);
        	
//            return new TextBuilder().build("你好啊，欢迎来到宠爱王国官方服务号\n" +
//                    "这里是宠集盒认证犬猫源数据平台\n" +
//                    "全国宠物店加盟入驻限量招募中!\n" +
//                    "戳此立刻申请入驻→ <a href=\"https://mp.weixin.qq.com/s/8FNpZ1gTeSXV_NKywX-Gdg\">官宣：认证犬猫数据源平台正式上线啦！首批入驻有惊喜</a>\n" +
//                    "---------\n" +
//                    "货源稳定，品种多样化\n" +
//                    "可认证，可查询，血统纯\n" +
//                    "线上销售，降低成本\n" +
//                    "\n"+
//                    "1、宠物店【报名申请】，请回复关键字【01】\n" +
//                    "\n"+
//                    "2、如果你是【繁殖者】，如何使用宠集盒？请回复关键字【02】\n" +
//                    "\n"+
//                    "3、宠集盒操作方法问答集锦，请回复关键字【03】\n" +
//                    "\n"+
//                    "4、CKU业务咨询，联系电话：400-660-7000\n" +
//                    "\n"+
//                    "5、阅读历史文章，请戳这里：<a href=\"https://mp.weixin.qq.com/mp/profile_ext?action=home&__biz=MzIwNDIwMjY1MA==&scene=126&bizpsid=0#wechat_redirect\">往期精选</a>\n", wxMessage, weixinService);
        	
        } catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }

        return null;
    }

    /**
     * 处理特殊请求，比如如果是扫码进来的，可以做相应处理
     */
    protected WxMpXmlOutMessage handleSpecial(WxMpXmlMessage wxMessage) throws Exception {
        //TODO
        return null;
    }

}
