package com.thinkgem.jeesite.common.utils;

import net.sf.json.JSONObject;

public class RESTResponse {
    private long rc;
    private String src;
    private String msg;
    private JSONObject data;

    private static boolean s_debug = false;

    static {
        int dbgLevel = 1;
        if (dbgLevel > 0) {
            s_debug = true;
        }
    }

    public RESTResponse() {
        this.rc = 0;
        this.msg = "OK";
    }

    public RESTResponse(long code, String message) {
        this.src = "za";
        this.msg = message;
        this.rc = code;
    }

    public RESTResponse(int code, String message) {
        this.src = "za";
        this.msg = message;
        this.rc = code;
    }

    public RESTResponse(JSONObject _data) {
        this.data = _data;
        this.rc = 0;
        this.msg = "OK";
    }

    public RESTResponse(String key, Object _data) {
        JSONObject dat = new JSONObject();
        dat.put(key, JSONUtils.convertObject(_data));

        this.data = dat;
        this.rc = 0;
        this.msg = "OK";
    }

    public <T> RESTResponse(String key, PageBeanResult<T> result) {
        JSONObject dat = new JSONObject();

        dat.put(key, JSONUtils.convertObject(result.list));
        dat.put("total", result.totalCount);

        this.data = dat;
        this.rc = 0;
        this.msg = "OK";
    }

    public long getRc() {
        return rc;
    }

    public void setRc(long _retCode) {
        this.rc = _retCode;
    }

    public String getSrc() {
        return src;
    }

    public void setSrc(String _source) {
        this.src = _source;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String _message) {
        this.msg = _message;
    }

    public JSONObject getData() {
        return data;
    }

    public void setData(JSONObject _data) {
        this.data = _data;
    }
}
