/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.tcbpetorder.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cab.passport.tcbpetorder.dao.DogNoseDao;
import com.cab.passport.tcbpetorder.dao.TcbPetOrderDao;
import com.cab.passport.tcbpetorder.entity.DogNose;
import com.cab.passport.tcbpetorder.entity.TcbPetOrder;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 鼻纹Service
 * 
 * @author xx
 * @version 2020-10-23
 */
@Service
@Transactional(readOnly = true)
public class DogNoseService extends CrudService<DogNoseDao, DogNose> {

	@Autowired
	private TcbPetOrderDao tcbPetOrderDao;

	public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

	public DogNose get(String id) {
		return super.get(id);
	}

	public List<DogNose> findList(DogNose dogNose) {
		return super.findList(dogNose);
	}

	public Page<DogNose> findPage(Page<DogNose> page, DogNose dogNose) {
		return super.findPage(page, dogNose);
	}

	@Transactional(readOnly = false)
	public void save(DogNose dogNose) {
		super.save(dogNose);
	}

	@Transactional(readOnly = false)
	public void delete(DogNose dogNose) {
		super.delete(dogNose);
	}

	public DogNose getOneByTcbPetOrderId(String tcbPetOrderId) {
		return dao.getOneByTcbPetOrderId(tcbPetOrderId);
	}

	public DogNose getOneByNoseId(String noseId) {
		return dao.getOneByNoseId(noseId);
	}

	@Transactional(readOnly = false)
	public String saveNoseId(String noseId, String tcbPetOrderId, String userId) {
		DogNose dogNose = getOneByTcbPetOrderId(tcbPetOrderId);
		if (dogNose != null)
			throw new ZAException("鼻纹已采集！");
		TcbPetOrder tcbPetOrder = tcbPetOrderDao.get(tcbPetOrderId);
		if (tcbPetOrder == null)
			throw new ZAException("ID错误！");

		DogNose dogNose2 = getOneByNoseId(noseId);
		if (dogNose2 != null)
			throw new ZAException("该鼻纹标识库中已存在！");
		dogNose = new DogNose();
		dogNose.setNoseId(noseId);
		dogNose.setTcbPetOrderId(tcbPetOrderId);
		dogNose.setCabPassport(tcbPetOrder.getCabPassport());
		dogNose.setIdentificationFlag(tcbPetOrder.getIdentificationFlag());
		dogNose.setNoseCode(getNextNoseCode());
		dogNose.preInsert();
		dogNose.setCreateBy(new User(userId));
		dogNose.setUpdateBy(dogNose.getCreateBy());
		dao.insert(dogNose);
		return dogNose.getId();
	}

	public String getNextNoseCode() {
		Integer num = dao.getMaxNoseCode();
		StringBuffer date = new StringBuffer("C");
		date.append(sdf.format(new Date()));
		if (num == null) {
			date.append("0000200");
			return date.toString();
		} else {
			num++;
			for (int i = 0; i < 7 - num.toString().length(); i++) {
				date.append('0');
			}
			date.append(num);
			return date.toString();
		}

	}

}