/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * votesEntity
 * @author wj
 * @version 2020-05-12
 */
public class School extends DataEntity<School> {

	private static final long serialVersionUID = 1L;
	private String schoolCode;		// 学校编号
	private String schoolName;		// 学校名字
	private String votes;		// 总票数
	private String catName;		// 猫品种
	private String catImg;		// 猫头像
	private String photo;		// 饭盒图片
	private String catDescription;		// 描述

	public School() {
		super();
	}

	public School(String id){
		super(id);
	}

	public String getCatName() {
		return catName;
	}

	public void setCatName(String catName) {
		this.catName = catName;
	}

	public String getCatDescription() {
		return catDescription;
	}

	public void setCatDescription(String catDescription) {
		this.catDescription = catDescription;
	}

	@Length(min=1, max=16, message="学校编号长度必须介于 1 和 16 之间")
	public String getSchoolCode() {
		return schoolCode;
	}

	public void setSchoolCode(String schoolCode) {
		this.schoolCode = schoolCode;
	}

	@Length(min=1, max=64, message="学校名字长度必须介于 1 和 64 之间")
	public String getSchoolName() {
		return schoolName;
	}

	public void setSchoolName(String schoolName) {
		this.schoolName = schoolName;
	}

	@Length(min=1, max=64, message="总票数长度必须介于 1 和 64 之间")
	public String getVotes() {
		return votes;
	}

	public void setVotes(String votes) {
		this.votes = votes;
	}

	@Length(min=0, max=255, message="猫头像长度必须介于 0 和 255 之间")
	public String getCatImg() {
		return catImg;
	}

	public void setCatImg(String catImg) {
		this.catImg = catImg;
	}

	@Length(min=0, max=255, message="饭盒图片长度必须介于 0 和 255 之间")
	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}

}