/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.dao;

import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

/**
 * 订单DAO接口
 *
 * @author lyy
 * @version 2016-08-04
 */
@MyBatisDao
public interface PaymentOrderDao extends CrudDao<PaymentOrder> {
	int locked(PaymentOrder paymentOrder);

	PaymentOrder getByorderCode(String orderCode);

	PaymentOrder getOrderByRunningNum(@Param("pedigreeNum") String pedigreeNum);

	String getOrderCount(PaymentOrder paymentOrder);

	void updateBusinessRunningNo(@Param("runningNumber") String runningNumber, @Param("tableName") String tableName,
                                 @Param("id") String id); // 更新业务表的订单流水信息


}