/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.offlineorder.entity;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 线下订单汇总表Entity
 * 
 * @author xx
 * @version 2020-10-12
 */
public class OfflineOrder extends DataEntity<OfflineOrder> {

	private static final long serialVersionUID = 1L;
	private Date orderTime; // 成交时间
	private String storeName; // 门店商家
	private String totalPrice; // 成交金额
	private String orderCode; // 订单编号
	private String petType; // 宠物种类:1狗;2猫
	private String petBreeds; // 品种
	private String petGender; // 宠物性别:1公;2母
	private String petCoatColor; // 毛色
	private Date petBirthdate; // 出生日期
	private String identificationFlag; // 芯片编号
	private String pedigreeCertified; // 宠爱护照号/血统证书号
	private String level; // 级别（血统/伴侣)
	private String expressState; // 物流状态
	private String isInsure; // 是否需要保险
	private String insurancePolicyRemark; // 保单操作阶段备注
	private String deliveryAddress; // 发货地
	private String customerName; // 客户姓名
	private String customerAddress; // 客户地址
	private Date beginOrderTime; // 开始 成交时间
	private Date endOrderTime; // 结束 成交时间

	public OfflineOrder() {
		super();
	}

	public OfflineOrder(String id) {
		super(id);
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "成交时间不能为空")
	public Date getOrderTime() {
		return orderTime;
	}

	public void setOrderTime(Date orderTime) {
		this.orderTime = orderTime;
	}

	@Length(min = 1, max = 20, message = "门店商家长度必须介于 1 和 20 之间")
	public String getStoreName() {
		return storeName;
	}

	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@Length(min = 1, max = 20, message = "订单编号长度必须介于 1 和 20 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	@Length(min = 1, max = 1, message = "宠物种类:1狗;2猫长度必须介于 1 和 1 之间")
	public String getPetType() {
		return petType;
	}

	public void setPetType(String petType) {
		this.petType = petType;
	}

	@Length(min = 0, max = 64, message = "品种长度必须介于 0 和 64 之间")
	public String getPetBreeds() {
		return petBreeds;
	}

	public void setPetBreeds(String petBreeds) {
		this.petBreeds = petBreeds;
	}

	@Length(min = 1, max = 1, message = "宠物性别:1公;2母长度必须介于 1 和 1 之间")
	public String getPetGender() {
		return petGender;
	}

	public void setPetGender(String petGender) {
		this.petGender = petGender;
	}

	@Length(min = 0, max = 64, message = "毛色长度必须介于 0 和 64 之间")
	public String getPetCoatColor() {
		return petCoatColor;
	}

	public void setPetCoatColor(String petCoatColor) {
		this.petCoatColor = petCoatColor;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPetBirthdate() {
		return petBirthdate;
	}

	public void setPetBirthdate(Date petBirthdate) {
		this.petBirthdate = petBirthdate;
	}

	@Length(min = 0, max = 255, message = "芯片编号长度必须介于 0 和 255 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min = 0, max = 255, message = "宠爱护照号/血统证书号长度必须介于 0 和 255 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 0, max = 20, message = "级别（血统/伴侣)长度必须介于 0 和 20 之间")
	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	@Length(min = 0, max = 20, message = "物流状态长度必须介于 0 和 20 之间")
	public String getExpressState() {
		return expressState;
	}

	public void setExpressState(String expressState) {
		this.expressState = expressState;
	}

	@Length(min = 0, max = 1, message = "是否需要保险长度必须介于 0 和 1 之间")
	public String getIsInsure() {
		return isInsure;
	}

	public void setIsInsure(String isInsure) {
		this.isInsure = isInsure;
	}

	@Length(min = 0, max = 255, message = "保单操作阶段备注长度必须介于 0 和 255 之间")
	public String getInsurancePolicyRemark() {
		return insurancePolicyRemark;
	}

	public void setInsurancePolicyRemark(String insurancePolicyRemark) {
		this.insurancePolicyRemark = insurancePolicyRemark;
	}

	@Length(min = 1, max = 200, message = "发货地长度必须介于 1 和 200 之间")
	public String getDeliveryAddress() {
		return deliveryAddress;
	}

	public void setDeliveryAddress(String deliveryAddress) {
		this.deliveryAddress = deliveryAddress;
	}

	@Length(min = 0, max = 20, message = "客户姓名长度必须介于 0 和 20 之间")
	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	@Length(min = 1, max = 200, message = "客户地址长度必须介于 1 和 200 之间")
	public String getCustomerAddress() {
		return customerAddress;
	}

	public void setCustomerAddress(String customerAddress) {
		this.customerAddress = customerAddress;
	}

	public Date getBeginOrderTime() {
		return beginOrderTime;
	}

	public void setBeginOrderTime(Date beginOrderTime) {
		this.beginOrderTime = beginOrderTime;
	}

	public Date getEndOrderTime() {
		return endOrderTime;
	}

	public void setEndOrderTime(Date endOrderTime) {
		this.endOrderTime = endOrderTime;
	}

}