/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.service;

import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.entity.PassportOrderBusinessStateEnum;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 护照订单Service
 *
 * @author lgl
 * @version 2018-10-09
 */
@Service
@Transactional(readOnly = true)
public class PassportOrderClubService extends CrudService<PassportOrderDao, PassportOrder> {

    @Transactional(readOnly = false)
    public void active(String identificationFlag, String consigneePhone) {
        PassportOrder po = dao.getByIdentificationFlagAndConsigneePhone(identificationFlag, consigneePhone);
        activeValidate(po);
        po.setBusinessState(PassportOrderBusinessStateEnum.IMPLANTED.getValue());
        String userId = UserUtils.getUser().getId();
        po.setActivateBy(StringUtils.isBlank(userId) ? "" : userId);
        po.setActivateDate(new Date());
        super.save(po);
    }

    @Transactional(readOnly = false)
    public void certify(PassportOrder passportOrder) {
        PassportOrder po = dao.get(passportOrder.getId());
        if (!"2".equals(po.getPackageType())) {
            throw new RuntimeException("未购买C级认证服务");
        }
        if (!PassportOrderBusinessStateEnum.IMPLANTED.getValue().equals(po.getBusinessState())) {
            throw new RuntimeException("只有已埋置的护照订单可以认证");
        }
        po.setBusinessState(PassportOrderBusinessStateEnum.CERTIFIED.getValue());
        po.setCertifyBy(UserUtils.getUser().getId());
        po.setCertifyDate(new Date());
        po.setCertifyResult(passportOrder.getCertifyResult());
        super.save(po);
    }

    public void activeValidate(PassportOrder po) {
        if (PassportOrderBusinessStateEnum.IMPLANTED.getValue().equals(po.getBusinessState()) && StringUtils.isBlank(po.getActivateBy())) {
            return;
        } else if (!PassportOrderBusinessStateEnum.FINISH.getValue().equals(po.getBusinessState())) {
            String userId = UserUtils.getUser().getId();
            String msg = "只有已完成的护照订单可以激活";
            if (StringUtils.isBlank(userId)) {
                throw new ZAException(msg);
            } else {
                throw new RuntimeException(msg);
            }
        }
    }

    public void certifyValidate(PassportOrder po) {
        if (!PassportOrderBusinessStateEnum.IMPLANTED.getValue().equals(po.getBusinessState())) {
            throw new RuntimeException("只有已埋置的护照订单可以认证");
        }
    }
}