package com.cab.passport.petstore.wx.builder;

import com.cab.passport.petstore.wx.service.WeixinService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage.Item;

/**
 * @author Binary Wang
 */
public class NewsBuilder {

    public WxMpXmlOutMessage build(String title,
                                   String description,
                                   String picUrl,
                                   String url,
                                   WxMpXmlMessage wxMessage,
                                   WeixinService service) {
        Item item = new Item();
        item.setTitle(title);
        item.setDescription(description);
        item.setPicUrl(picUrl);
        item.setUrl(url);
        WxMpXmlOutNewsMessage m = WxMpXmlOutMessage.NEWS().addArticle(item)
                .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                .build();
        return m;
    }

}
