package com.cab.passport.passportorder.service;

import com.cab.passport.passportorder.dao.CompanionDogAppraisalDao;
import com.cab.passport.passportorder.entity.CompanionDogAppraisal;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.ZAException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 伴侣级鉴定Service
 *
 * @author pp
 * @version 2019-07-04
 */
@Service
@Transactional(readOnly = true)
public class CompanionDogAppraisalService extends CrudService<CompanionDogAppraisalDao, CompanionDogAppraisal> {


    public CompanionDogAppraisal get(String id) {
        return super.get(id);
    }


    public List<CompanionDogAppraisal> findList(CompanionDogAppraisal companionDogAppraisal) {
        return super.findList(companionDogAppraisal);
    }

    public Page<CompanionDogAppraisal> findPage(Page<CompanionDogAppraisal> page, CompanionDogAppraisal companionDogAppraisal) {
        return super.findPage(page, companionDogAppraisal);
    }

    @Transactional(readOnly = false)
    public void save(CompanionDogAppraisal companionDogAppraisal) {
        super.save(companionDogAppraisal);
    }

    @Transactional(readOnly = false)
    public void delete(CompanionDogAppraisal companionDogAppraisal) {
        super.delete(companionDogAppraisal);
    }

    @Transactional(readOnly = false)
    public String identityPrint(String id) {
        CompanionDogAppraisal companionDogAppraisal =  dao.get(id);
        if (companionDogAppraisal == null) {
            throw new ZAException("犬只信息错误");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getPassportNo())) {
            throw new ZAException("护照号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getCabRegisterCode())) {
            throw new ZAException("宠爱登记卡号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getIdentificationFlag())) {
            throw new ZAException("芯片号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getAppraisalResult()) && "1".equals(companionDogAppraisal.getAppraisalResult())) {
            throw new ZAException("犬只鉴定未通过");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getPaymentState()) && "2".equals(companionDogAppraisal.getPaymentState())) {
            throw new ZAException("犬只未交费");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getIdentitySticker()) && !"0".equals(companionDogAppraisal.getIdentitySticker())) {
            throw new ZAException("身份贴纸已打印");
        }
        companionDogAppraisal.setIdentitySticker("1");
        companionDogAppraisal.setIdentityPrintTime(new Date());
        dao.update(companionDogAppraisal);
        return "passportOrder/identityPrint";

    }

    @Transactional(readOnly = false)
    public String gradePrint(String id) {
        CompanionDogAppraisal companionDogAppraisal = dao.get(id);
        if (companionDogAppraisal == null) {
            throw new ZAException("犬只信息错误");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getPassportNo())) {
            throw new ZAException("护照号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getClassCode())) {
            throw new ZAException("贴纸编号号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getIdentificationFlag())) {
            throw new ZAException("芯片号为空");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getAppraisalResult()) && "1".equals(companionDogAppraisal.getAppraisalResult())) {
            throw new ZAException("犬只鉴定未通过");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getPaymentState()) && "2".equals(companionDogAppraisal.getPaymentState())) {
            throw new ZAException("犬只未交费");
        }
        if (StringUtils.isBlank(companionDogAppraisal.getGradeSticker()) && !"0".equals(companionDogAppraisal.getGradeSticker())) {
            throw new ZAException("等级贴纸已打印");
        }
        companionDogAppraisal.setGradeSticker("1");
        companionDogAppraisal.setGradePrintTime(new Date());
        dao.update(companionDogAppraisal);
        return "passportOrder/gradePrint";

    }

    @Transactional(readOnly = false)
    public void restIdentityPrint(String id) {
        CompanionDogAppraisal companionDogAppraisal = dao.get(id);
        if (companionDogAppraisal == null) {
            throw new ZAException("犬只信息错误");
        }
        companionDogAppraisal.setIdentitySticker("0");
        dao.update(companionDogAppraisal);
    }

    @Transactional(readOnly = false)
    public void restGradePrint(String id) {
        CompanionDogAppraisal companionDogAppraisal = dao.get(id);
        if (companionDogAppraisal == null) {
            throw new ZAException("犬只信息错误");
        }
        companionDogAppraisal.setGradeSticker("0");
        dao.update(companionDogAppraisal);
    }

}