package com.cab.passport.advertising.web;

import com.cab.passport.advertising.dao.BannerDao;
import com.cab.passport.advertising.entity.Banner;
import com.cab.passport.advertising.service.BannerService;
import com.cab.passport.common.ResultVo;
import com.cab.passport.common.ResultVoUtil;
import com.thinkgem.jeesite.common.web.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 繁育人BannerController
 *
 * @author lgl
 * @version 2017-10-11
 */
@Controller
@RequestMapping(value = "/advertising")
public class BannerPubController extends BaseController {
    protected Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private BannerService bannerService;
    @Autowired
    private BannerDao bannerDao;

    @RequestMapping(value = "getOne", method = RequestMethod.GET)
    @ResponseBody
    public ResultVo<Banner> getOne(HttpServletRequest request) {
        int count= bannerDao.getCount();
        if(count==0){
            logger.warn("得到广告返回值："+ ResultVoUtil.noDate(null));
            return ResultVoUtil.noDate(null);
        }
        String  indexS="";
        int index=1;
        if(null!=request.getSession().getAttribute("advertisingIndex")){
            indexS=request.getSession().getAttribute("advertisingIndex").toString();
            if(Integer.parseInt(indexS)>count){
                index=1;
            }else{
                index=Integer.parseInt(indexS);
            }
        }
        Banner banner=bannerService.getOne((index-1));
        index++;
        //存入缓存
        request.getSession().setAttribute("advertisingIndex",index);
        String imgPath = "http://" + request.getHeader("host") + request.getContextPath()  + "/pub/file/image/" + banner.getImg();
        banner.setImg(imgPath);
        logger.warn("得到广告返回值："+ ResultVoUtil.success(banner));
        return ResultVoUtil.success(banner);
    }

}