/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.web;

import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.cab.passport.passportorder.service.PassportOrderClubService;
import com.cab.passport.passportorder.service.PassportOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 护照订单Controller
 *
 * @author lgl
 * @version 2018-10-09
 */
@Controller
@RequestMapping(value = "${adminPath}/passportOrder/club")
public class PassportOrderClubController extends BaseController {

    @Autowired
    private PassportOrderService passportOrderService;
    @Autowired
    private PassportOrderClubService passportOrderClubService;
    @Autowired
    private PassportOrderDao passportOrderDao;
    @Autowired
    private UserDao userDao;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/passportOrder/club/";

    private static final String AUTHORITY_PRDFIX = "passportOrder:club:";

    @ModelAttribute
    public PassportOrder get(@RequestParam(required = false) String id) {
        PassportOrder entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = passportOrderService.get(id);
        }
        if (entity == null) {
            entity = new PassportOrder();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "activeList")
    public String activeList(PassportOrder passportOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        User user = UserUtils.getUser();
        if (StringUtils.isNotBlank(user.getId()) && !"1".equals(user.getId())) {
            passportOrder.setActivateBy(user.getId());
        }
        passportOrder.setActivateDateNotNull("1");
        Page<PassportOrder> page = passportOrderService.findPage(new Page<PassportOrder>(request, response), passportOrder);
        for (PassportOrder po : page.getList()) {
            if (StringUtils.isNotBlank(po.getActivateBy())) {
                user = userDao.get(po.getActivateBy());
                po.setActivateBy(user.getLoginName());
            }
        }
        model.addAttribute("page", page);
        return "passportOrder/passportOrderClubActiveList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "certifyList")
    public String certifyList(PassportOrder passportOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
        User user = UserUtils.getUser();
        if (StringUtils.isNotBlank(user.getId()) && !"1".equals(user.getId())) {
            passportOrder.setCertifyBy(user.getId());
        }
        passportOrder.setCertifyDateNotNull("1");
        Page<PassportOrder> page = passportOrderService.findPage(new Page<PassportOrder>(request, response), passportOrder);
        for (PassportOrder po : page.getList()) {
            if (StringUtils.isNotBlank(po.getCertifyBy())) {
                user = userDao.get(po.getCertifyBy());
                po.setCertifyBy(user.getLoginName());
            }
        }
        model.addAttribute("page", page);
        return "passportOrder/passportOrderClubCertifyList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "searchForm")
    public String searchForm(HttpServletRequest request, Model model) {
        model.addAttribute("type", request.getParameter("type"));
        return "passportOrder/passportOrderClubSearchForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "search")
    public String search(HttpServletRequest request, PassportOrder passportOrder, Model model) {
        String type = request.getParameter("type");
        PassportOrder po = passportOrderDao.getByIdentificationFlagAndConsigneePhone(passportOrder.getIdentificationFlag(), passportOrder.getConsigneePhone());
        if (po == null) {
            throw new RuntimeException("\n" +
                    "\n" +
                    "输入信息不符，请核对后从新输入\n" +
                    "\n" +
                    "芯片号为即将注册芯片号码\n" +
                    "\n" +
                    "手机号为用户购买时的收货手机号\n");
        }
        if ("active".equals(type)) {
            passportOrderClubService.activeValidate(po);
        } else if ("certify".equals(type)) {
            passportOrderClubService.certifyValidate(po);
        }
        model.addAttribute("passportOrder", po);
        model.addAttribute("type", type);
        return "passportOrder/passportOrderClubActiveForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "active")
    public String active(PassportOrder passportOrder) {
        passportOrderClubService.active(passportOrder.getIdentificationFlag(), passportOrder.getConsigneePhone());
        if (StringUtils.isNotBlank(passportOrder.getCertifyResult())) {
            passportOrderClubService.certify(passportOrder);
        }
        return REPAGE + "activeList?repage";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "certify")
    public String certify(PassportOrder passportOrder) {
        passportOrderClubService.certify(passportOrder);
        return REPAGE + "certifyList?repage";
    }

}