/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.service;

import com.cab.passport.sys.payment.dao.PaymentChargingItemDao;
import com.cab.passport.sys.payment.dao.PaymentOrderDao;
import com.cab.passport.sys.payment.dao.PaymentOrderDetailDao;
import com.cab.passport.sys.payment.dao.PaymentRecordDao;
import com.cab.passport.sys.payment.entity.PaymentChargingItem;
import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.cab.passport.sys.payment.entity.PaymentOrderDetail;
import com.cab.passport.sys.util.SysCodeUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.ZAException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 订单Service
 *
 * @author lyy
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class PaymentOrderService extends CrudService<PaymentOrderDao, PaymentOrder> {
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;

	public static final String DOG_APPRAISAL = "dog_appraisal";


	private Logger logger = LoggerFactory.getLogger(PaymentOrderService.class);

	public PaymentOrder get(String id, String getByorderCode) {
		PaymentOrder paymentOrder = null;
		if (!StringUtils.isBlank(id)) {
			paymentOrder = super.get(id);
		} else {
			paymentOrder = paymentOrderDao.getByorderCode(getByorderCode);
		}
		if (paymentOrder != null && paymentOrder.getOrderCode() != null && !paymentOrder.getOrderCode().equals("")) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
					.findList(new PaymentOrderDetail(paymentOrder));
			if (orderDetailList != null && orderDetailList.size() > 0) {
				orderDetailList.forEach(item -> {
					String chargingItemId = item.getChargingItemId();
					item.setPaymentChargingItem(
							paymentChargingItemService.get(new PaymentChargingItem(chargingItemId)));
				});
			}
			paymentOrder.setOrderDetailList(orderDetailList);
		}
		return paymentOrder;
	}

	public List<PaymentOrder> findList(PaymentOrder paymentOrder) {
		return super.findList(paymentOrder);
	}

	public String getOrderCount(PaymentOrder paymentOrder) {
		return dao.getOrderCount(paymentOrder);
	}

	public Page<PaymentOrder> findPage(Page<PaymentOrder> page, PaymentOrder paymentOrder) {
		return super.findPage(page, paymentOrder);
	}

	@Transactional(readOnly = false)
	public void delete(PaymentOrder paymentOrder) {
		super.delete(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void locked(PaymentOrder paymentOrder) {
		paymentOrder.setLocked("0".equals(paymentOrder.getLocked()) ? "1" : "0");
		dao.locked(paymentOrder);
	}


	/**
	 * 根据订单号查找
	 *
	 * @Author chaixueteng
	 * @2016年10月18日下午2:18:09
	 */
	public PaymentOrder getByOrderCode(String orderCode) {
		return dao.getOrderByRunningNum(orderCode);
	}

	/**
	 *
	 * @description: 根据流水号获取支付时间
	 * @author: laiguanglong
	 * @date: 2016年11月4日 下午5:14:55
	 */
	public Date getPaymentTimeByOrderCode(String orderCode) {
		return dao.getOrderByRunningNum(orderCode).getPaymentTime();
	}


	/**
	 * 保存订单
	 *
	 * @param paymentOrder
	 * @param orderTotal
	 * @param addTime
	 */
	@Transactional(readOnly = false)
	public void saveOrder(PaymentOrder paymentOrder, Double orderTotal, Date addTime) {
		// 插入订单
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(paymentOrder.getMemberCode());
		paymentOrder.setOrderCode(runningNumber);
		paymentOrder.setAddTime(addTime);
		paymentOrder.setLocked("0");
		paymentOrder.setTotalPrice(orderTotal.toString());
		paymentOrder.setPaymentState("1");
		paymentOrder.setSource("");
		paymentOrder.preInsert();
		paymentOrderDao.insert(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void afterPay(PaymentOrder paymentOrder) {
		updatePaymentOrder(paymentOrder);
		// 更新业务表
		updateBusiness(paymentOrder);
		// 写入流水表
		insertPaymentRecord(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void updatePaymentOrder(PaymentOrder paymentOrder) {
		paymentOrder.setPaymentState("2");
		paymentOrder.setPaymentTime(new Date());
		// paymentOrder.setOrderCode(runningNum);
		paymentOrder.preUpdate();
		paymentOrderDao.update(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void insertPaymentRecord(PaymentOrder paymentOrder) {
		paymentRecordService.addRecordByOrder(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void updateBusiness(PaymentOrder paymentOrder) {
		// 因为原来查询出来的订单详情都是未删除的，所以再次查询订单详情，已删除的也查
		if (paymentOrder != null && paymentOrder.getOrderCode() != null && !paymentOrder.getOrderCode().equals("")) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.getOrderByRunningNum(paymentOrder.getOrderCode());
			if (orderDetailList != null && orderDetailList.size() > 0) {
				orderDetailList.forEach(item -> {
					String chargingItemId = item.getChargingItemId();
					item.setPaymentChargingItem(
							paymentChargingItemService.get(new PaymentChargingItem(chargingItemId)));
				});
			}
			paymentOrder.setOrderDetailList(orderDetailList);
		}
		// 根据业务订单详情里的收费项去更新相应业务表的收费状态
		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrder.getOrderDetailList();
		int i = 0;
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 一个业务收费项为多个的情况下，只把主要业务的收费项的业务表设置上，这样只更新业务表不为空的收费详情
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())) {
				String sql = bulidSql(paymentOrderDetail);
				int j = paymentRecordDao.changePaymentState(sql);
				if (j <= 0) {
					throw new ZAException("修改业务状态失败！");
				}
			}
		}
	}

	private String bulidSql(PaymentOrderDetail paymentOrderDetail) {
		StringBuffer buffer = new StringBuffer(128);
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentOrderDetail.getChargingItemId());
		String shortName = paymentChargingItem.getShortName();
		String tableName;
		if (StringUtils.isBlank(shortName)) {
			tableName = paymentOrderDetail.getBusinessTable();
		} else {
			tableName = shortName.split("@")[0];
		}
		String businessIds = paymentOrderDetail.getBusinessIds();
		if (DOG_APPRAISAL.equals(tableName)) {// 出生证明业务记录表根据父母配种证明号进行批量更新
			buffer.append(
					"UPDATE dog_appraisal SET payment_state = 2,payment_time = now() WHERE id = '")
					.append(businessIds.trim()).append("'");
		}
		return buffer.toString();
	}

}