/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.service;

import com.cab.passport.sys.payment.dao.PaymentChargingItemDao;
import com.cab.passport.sys.payment.entity.PaymentChargingItem;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 收费项目Service
 *
 * @author lyy
 * @version 2016-07-21
 */
@Service
@Transactional(readOnly = true)
public class PaymentChargingItemService extends CrudService<PaymentChargingItemDao, PaymentChargingItem> {

	public PaymentChargingItem get(String id) {
		return super.get(id);
	}

	public List<PaymentChargingItem> findList(PaymentChargingItem paymentChargingItem) {
		return super.findList(paymentChargingItem);
	}

	public List<PaymentChargingItem> getFeesAndCharges() {
		return dao.getFeesAndCharges();
	}

	public List<PaymentChargingItem> findAllList(PaymentChargingItem paymentChargingItem) {
		List<PaymentChargingItem> result = null;
		if (CacheUtils.get("chargingItems") == null) {
			result = dao.findAllList(paymentChargingItem);
			CacheUtils.put("chargingItems", result);
		} else {
			result = (List<PaymentChargingItem>) CacheUtils.get("chargingItems");
		}

		return result;
	}

	public Page<PaymentChargingItem> findPage(Page<PaymentChargingItem> page, PaymentChargingItem paymentChargingItem) {
		return super.findPage(page, paymentChargingItem);
	}

	@Transactional(readOnly = false)
	public void save(PaymentChargingItem paymentChargingItem) {
		super.save(paymentChargingItem);
	}

	@Transactional(readOnly = false)
	public void delete(PaymentChargingItem paymentChargingItem) {
		super.delete(paymentChargingItem);
	}

	public PaymentChargingItem getByShortName(String shortName) {
		return dao.getByShortName(shortName);
	}

	/**
	 * @param code
	 *            根据部门编号查询部门的收费项
	 * @return
	 */
	public List<PaymentChargingItem> findListByDeptCode(String code) {
		List<PaymentChargingItem> reslut = new ArrayList<PaymentChargingItem>();
		List<PaymentChargingItem> list = dao.findListByDeptCode(code);
		// 非财务部门不可以退费
		if (code != null && code.length() > 0) {
			for (PaymentChargingItem paymentChargingItem : list) {
				if (!paymentChargingItem.getName().contains("退费")) {
					reslut.add(paymentChargingItem);
				}
			}
		} else {
			reslut = list;
		}
		return reslut;
	}

	public List<PaymentChargingItem> findListByIds(List<String> ids) {
		return dao.findListByIds(ids);
	}

	public List<PaymentChargingItem> findTypeList(String type) {
		return dao.findTypeList(type);
	}

	/**
	 * @Description：根据收费项目名称获取收费项目编号
	 * @author: zhuoHeng
	 * @version: 2016年7月25日 下午3:47:17
	 */
	public String getPaymentCode(String name) {

		String id;
		PaymentChargingItem PaymentChargingItem = new PaymentChargingItem();
		StringBuffer sb = new StringBuffer();
		sb.append("犬只参赛费（");
		sb.append(name + "）");
		PaymentChargingItem = dao.getPaymentCode(sb.toString());
		id = PaymentChargingItem.getId();

		return id;
	}

	/**
	 * @description: 根据收费项目shortName前缀查询
	 * @author: laiguanglong
	 * @date: 2016年7月29日 下午2:25:41
	 */
	public List<PaymentChargingItem> getByShortNamePrefix(String shortName) {
		return dao.getByShortNamePrefix(shortName);
	}
}