/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.sys.service;

import com.ckfinder.connector.utils.FileUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.dao.FileDao;
import com.thinkgem.jeesite.modules.sys.entity.BaseFile;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

/**
 * 文件模块Service
 *
 * @author rain
 * @version 2015-12-18
 */
@Service
@Transactional(readOnly = false)
public class FileService extends CrudService<FileDao, BaseFile> {

    public static String fileDir;

    @Autowired
    private FileDao filedao;

    public BaseFile get(String id) {
        return super.get(id);
    }

    public List<BaseFile> findList(BaseFile sysFile) {
        return super.findList(sysFile);
    }

    public Page<BaseFile> findPage(Page<BaseFile> page, BaseFile sysFile) {
        return super.findPage(page, sysFile);
    }

    @Transactional(readOnly = false)
    public void save(BaseFile sysFile) {
        super.save(sysFile);
    }

    @Transactional(readOnly = false)
    public void delete(BaseFile sysFile) {
        super.delete(sysFile);
    }

    @PostConstruct
    public void a() {
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("windows")) {
            fileDir = Global.getConfig("windows.file.dir");
        } else {
            fileDir = Global.getConfig("linux.file.dir");
        }
        logger.info("文件保存路径为" + FileService.fileDir);
    }

    public BaseFile uploadFile(MultipartFile multiFile, String module, String state) {
        String extensionPath = getExtensionPath(module);
        String path = getFullDir(extensionPath);
        // 上传实际的文件
        File file = upload(multiFile, path);
        return createBaseFile(multiFile, file, extensionPath, state);
    }

    public BaseFile watermarkImg(MultipartFile multiFile, String module, String state) {
        String extensionPath = getExtensionPath(module);
        String path = getFullDir(extensionPath);
        // 上传实际的文件
        File file = upload(multiFile, path);
        watermark(file);
        return createBaseFile(multiFile, file, extensionPath, state);
    }

    private BaseFile createBaseFile(MultipartFile multiFile, File file, String extensionPath, String state) {
        // 插入一条数据库记录
        BaseFile baseFile = new BaseFile();
        baseFile.setName(file.getName());
        baseFile.setOrginalname(multiFile.getOriginalFilename());
        baseFile.setType(multiFile.getContentType());
        baseFile.setExtension(FileUtils.getFileExtension(multiFile.getOriginalFilename()));
        baseFile.setSize(multiFile.getSize());
        baseFile.setLocation(extensionPath);
        baseFile.setDescription(null);
        baseFile.setOwnerid(UserUtils.getUser().getId());
        baseFile.setOwnername(UserUtils.getUser().getName());
        baseFile.setStatus("0");
        baseFile.setOpenFlag(state);
        if (StringUtils.isBlank(UserUtils.getUser().getId())) {
            User user = new User("1");
            baseFile.setCreateBy(user);
            baseFile.setUpdateBy(user);
        }
        super.save(baseFile);
        return baseFile;
    }


    public void deleteFile(BaseFile BaseFile) {
        File file = new File(BaseFile.getLocation());
        file.delete(); //删除文件
        filedao.delete(BaseFile);//删除文件记录
    }

    public String getExtensionPath(String module) {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        String path = module + File.separator + calendar.get(Calendar.YEAR) + File.separator + (calendar.get(Calendar.MONTH) + 1);
        return path;
    }

    // TODO 获取基本的路径
    public String getFullDir(String extensionPath) {
        String path = fileDir + File.separator + extensionPath;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path + File.separator;
    }

    // 上传文件到实际的物理地址
    public File upload(MultipartFile multiFile, String path) {
        String fileName = path + IdGen.uuid() + "." + FileUtils.getFileExtension(multiFile.getOriginalFilename());
        //文件名以UUID来命名
        File file = new File(fileName);
        try {
            multiFile.transferTo(file);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static final void watermark(File targetFile) {
        FileOutputStream out = null;
        try {
            // 目标文件
            Image src = ImageIO.read(targetFile);
            int wideth = src.getWidth(null);
            int height = src.getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, BufferedImage.TYPE_INT_RGB);
            Graphics g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);

            String fileName = "petLostAndFoundWatermark.png";
            // 水印文件
            Image watermark = ImageIO.read(new FileInputStream(FileService.class.getResource("/").getPath() + fileName));
            int watermarkWideth = watermark.getWidth(null);
            int watermarkHeight = watermark.getHeight(null);
            int y = (height - watermarkHeight) / 2;
            g.drawImage(watermark, wideth - watermarkWideth, y, watermarkWideth, watermarkHeight, null);
            // 水印文件结束
            g.dispose();

            out = new FileOutputStream(targetFile);
            ImageIO.write(image, "jpg", out);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void main(String[] args) {
        File f = new File("C://1.jpg");
        watermark(f);
    }
}