/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.dao;

import com.cab.passport.sys.payment.entity.PaymentChargingItem;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 收费项目DAO接口
 *
 * @author lyy
 * @version 2016-07-21
 */
@MyBatisDao
public interface PaymentChargingItemDao extends CrudDao<PaymentChargingItem> {
	PaymentChargingItem getByShortName(String shortName);

	List<PaymentChargingItem> findListByDeptCode(@Param("code") String code);

	List<PaymentChargingItem> findListByIds(@Param("ids") List<String> ids);

	List<PaymentChargingItem> findTypeList(@Param("type") String type);

	List<PaymentChargingItem> getFeesAndCharges();

	/**
	 * @Description：根据收费项目名称获取收费项目编号
	 * @author: zhuoHeng
	 * @version: 2016年7月25日 下午3:48:57
	 */
	PaymentChargingItem getPaymentCode(String name);

	/**
	 * @description: 根据收费项目shortName前缀查询
	 * @author: laiguanglong
	 * @date: 2016年7月29日 下午2:20:06
	 */
	List<PaymentChargingItem> getByShortNamePrefix(String shortName);

	Map getTableByJumpUrl(String jumpUrl);

	List<PaymentChargingItem> getNegativeItems();

}