/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.offlineorder.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cab.passport.offlineorder.entity.OfflineOrder;
import com.cab.passport.offlineorder.service.OfflineOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 线下订单汇总表Controller
 * 
 * @author xx
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/offlineorder/offlineOrder")
public class OfflineOrderController extends BaseController {

	@Autowired
	private OfflineOrderService offlineOrderService;

	@ModelAttribute
	public OfflineOrder get(@RequestParam(required = false) String id) {
		OfflineOrder entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = offlineOrderService.get(id);
		}
		if (entity == null) {
			entity = new OfflineOrder();
		}
		return entity;
	}

	@RequiresPermissions("offlineorder:offlineOrder:view")
	@RequestMapping(value = { "list", "" })
	public String list(OfflineOrder offlineOrder, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<OfflineOrder> page = offlineOrderService.findPage(new Page<OfflineOrder>(request, response), offlineOrder);
		model.addAttribute("page", page);
		return "offlineorder/offlineOrderList";
	}

	@RequiresPermissions("offlineorder:offlineOrder:view")
	@RequestMapping(value = "form")
	public String form(OfflineOrder offlineOrder, Model model) {
		model.addAttribute("offlineOrder", offlineOrder);
		return "offlineorder/offlineOrderForm";
	}

	@RequiresPermissions("offlineorder:offlineOrder:edit")
	@RequestMapping(value = "save")
	public String save(OfflineOrder offlineOrder, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, offlineOrder)) {
			return form(offlineOrder, model);
		}
		offlineOrderService.save(offlineOrder);
		addMessage(redirectAttributes, "保存线下订单汇总表成功");
		return "redirect:" + Global.getAdminPath() + "/offlineorder/offlineOrder/?repage";
	}

	@RequiresPermissions("offlineorder:offlineOrder:edit")
	@RequestMapping(value = "delete")
	public String delete(OfflineOrder offlineOrder, RedirectAttributes redirectAttributes) {
		offlineOrderService.delete(offlineOrder);
		addMessage(redirectAttributes, "删除线下订单汇总表成功");
		return "redirect:" + Global.getAdminPath() + "/offlineorder/offlineOrder/?repage";
	}

}