<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>淘宠宝宠物订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/tcbPetOrder/">活体订单数据管理</a></li>
    <shiro:hasPermission name="tcbPetOrder:edit">
        <li><a href="${ctx}/tcbPetOrder/form">活体订单数据添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="tcbPetOrder" action="${ctx}/tcbPetOrder/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>天猫订单号：</label>
            <form:input path="tmallOrderCode" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>芯片号：</label>
            <form:input path="identificationFlag" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>护照号：</label>
            <form:input path="cabPassport" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠物种类：</label>
            <form:select path="petType" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('pet_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>

        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>交易时间</th>
        <th>制作时间</th>
        <th>天猫订单号</th>
        <th>宠物名</th>
        <th>性别</th>
        <th>毛色</th>
        <th>宠物种类</th>
        <th>品种</th>
        <th>出生日期</th>
        <th>芯片号</th>
        <th>护照号</th>
        <th>鼻纹状态</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="tcbPetOrder">
        <tr>
            <td>
                <fmt:formatDate value="${tcbPetOrder.orderTime}" pattern="yyyy年MM月dd日"/>
            </td>
            <td>
                <fmt:formatDate value="${tcbPetOrder.produceDate}" pattern="yyyy年MM月dd日"/>
            </td>
            <td>
                    ${tcbPetOrder.tmallOrderCode}
            </td>
            <td>
                    ${tcbPetOrder.petName}
            </td>
            <td>
                    ${fns:getDictLabel(tcbPetOrder.petGender, 'pet_gender', '')}
            </td>
            <td>
                    ${tcbPetOrder.petCoatColor}
            </td>
            <td>
                    ${fns:getDictLabel(tcbPetOrder.petType, 'pet_type', '')}
            </td>
            <td>
                    ${tcbPetOrder.petBreed}
            </td>
            <td>
                <fmt:formatDate value="${tcbPetOrder.petBirthday}" pattern="yyyy年MM月dd日"/>
            </td>
            <td>
                    ${tcbPetOrder.identificationFlag}
            </td>
            <td>
                    ${tcbPetOrder.cabPassport}
            </td>
              <td>
              		<c:if test="${tcbPetOrder.noseCode !=null and tcbPetOrder.noseCode !=''}">已采集</c:if>
              
                	<c:if test="${tcbPetOrder.noseCode ==null or tcbPetOrder.noseCode ==''}">
                		<font color="red">待采集</font>
                    </c:if>
                  
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>