package com.cab.passport.advertising.service;

import com.cab.passport.advertising.dao.BannerDao;
import com.cab.passport.advertising.entity.Banner;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 繁育人BannerService
 *
 * @author lgl
 * @version 2017-10-11
 */
@Service
@Transactional(readOnly = true)
public class BannerService extends CrudService<BannerDao, Banner> {
    @Autowired
    private BannerDao bannerDao;

    public Banner get(String id) {
        return super.get(id);
    }
    public Banner getOne(int id) {
        return bannerDao.getOne(id);
    }
    public Banner getOneBySort(int id) {
        return bannerDao.getOneBySort(id);
    }

    public List<Banner> findList(Banner banner) {
        return super.findList(banner);
    }

    public Page<Banner> findPage(Page<Banner> page, Banner banner) {
        return super.findPage(page, banner);
    }

    @Transactional(readOnly = false)
    public void save(Banner banner) {
        super.save(banner);
    }

    @Transactional(readOnly = false)
    public void delete(Banner banner) {
        super.delete(banner);
    }

}