package com.cab.passport.sys.payment.web;

import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.cab.passport.sys.payment.entity.Unifiedorder;
import com.cab.passport.sys.payment.entity.WXPayResult;
import com.cab.passport.sys.payment.service.PaymentOrderService;
import com.cab.passport.sys.util.*;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 *
 * <p>Title:CabWeixinPayController </p>
 * <p>Description: 宠爱王国微信支付</p>
 * <p>Company: </p>
 * @author zhuoHeng
 * @date 2016年12月22日 下午2:06:04
 */
@Controller
@RequestMapping(value = "/pub/cabWxPay")
public class MobileWeChatPayController {

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private  PaymentOrderService orderService;


	private Logger logger = LoggerFactory.getLogger(MobileWeChatPayController.class);

	@RequestMapping("/getPrepayId")
	@ResponseBody
	@SuppressWarnings("all")
	public RESTResponse getPrepayId(HttpServletRequest request,HttpServletResponse response) throws IOException{

		//判断订单是否存在，是否为未付款
		String totalPrice = "";
		String memberName = "";
		String title = "";
		String orderId = request.getParameter("orderId");
		String ip = request.getRemoteAddr();
		String path = request.getContextPath();
		String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path;
		if (request.getHeader("x-forwarded-for") == null) {
			ip = request.getRemoteAddr();
		}else{
			ip = request.getHeader("x-forwarded-for");
		}
		PaymentOrder order = paymentOrderService.get(orderId);
		//如果订单已删除。报错提示
		if("1".equals(order.getDelFlag())){
			throw new ZAException("该订单已删除，请勿支付");
		}
		if(order != null && order.getPaymentState().equals("1")){
			totalPrice = order.getTotalPrice();
			memberName = order.getMemberName();
			title = "CKU业务扣费";
		}

		WeixinConfigUtils config = new WeixinConfigUtils();
		//参数组
		String appid = config.appid;
		String mch_id = config.mch_id;
		String nonce_str = RandCharsUtils.getRandomString(16);
		String body = "CKU业务订单支付";
		String attach = "备用参数，先留着，后面会有用的";
		String out_trade_no = orderId;
		//TODO 调整订单金额为真实订单金额
		int total_fee = new BigDecimal(totalPrice).intValue()*100;//单位是分
		String spbill_create_ip = ip;
		String time_start = RandCharsUtils.timeStart();
		String time_expire = RandCharsUtils.timeExpire();
		String notify_url = basePath + config.notify_url;
		String trade_type = "APP";


		//参数：开始生成签名
		SortedMap<Object,Object> parameters = new TreeMap<Object,Object>();
		parameters.put("appid", appid);
		parameters.put("mch_id", mch_id);
		parameters.put("nonce_str", nonce_str);
		parameters.put("body", body);
		parameters.put("attach", attach);
		parameters.put("out_trade_no", out_trade_no);
		parameters.put("total_fee", total_fee);
		parameters.put("time_start", time_start);
		parameters.put("time_expire", time_expire);
		parameters.put("notify_url", notify_url);
		parameters.put("trade_type", trade_type);
		parameters.put("spbill_create_ip", spbill_create_ip);
		//构造签名
		String sign = WXSignUtils.createSign("UTF-8", parameters);

		//xml构造对象
		Unifiedorder unifiedorder = new Unifiedorder();
		unifiedorder.setAppid(appid);
		unifiedorder.setMch_id(mch_id);
		unifiedorder.setNonce_str(nonce_str);
		unifiedorder.setSign(sign);
		unifiedorder.setBody(body);
		unifiedorder.setAttach(attach);
		unifiedorder.setOut_trade_no(out_trade_no);
		unifiedorder.setTotal_fee(total_fee);
		unifiedorder.setSpbill_create_ip(spbill_create_ip);
		unifiedorder.setTime_start(time_start);
		unifiedorder.setTime_expire(time_expire);
		unifiedorder.setNotify_url(notify_url);
		unifiedorder.setTrade_type(trade_type);


		//构造xml参数
		String xmlInfo = HttpXmlUtils.xmlInfo(unifiedorder);
		logger.debug("xmlInfo"+xmlInfo);

		String wxUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
		String method = "POST";
		String weixinPost = HttpXmlUtils.httpsRequest(wxUrl, method, xmlInfo).toString();

		logger.debug(weixinPost);

		Map<String, String> map = ParseXMLUtils.jdomParseXml(weixinPost);
		SortedMap<Object,Object> sortedMap = new TreeMap<Object,Object>();
		sortedMap.put("appid", appid);
		sortedMap.put("partnerid", mch_id);
		sortedMap.put("prepayid", map.get("prepay_id"));
		sortedMap.put("package", "Sign=WXPay");
		sortedMap.put("noncestr", nonce_str);
		sortedMap.put("timestamp", new Date().getTime()/1000);

		//二次构造签名
		String sign2 = WXSignUtils.createSign("UTF-8", sortedMap);
		sortedMap.put("sign",sign2);

		RESTResponse result = new RESTResponse("data",sortedMap);
		return  result;
	}


	/**
	 * 宠爱王国微信支付回调
	 * @param request
	 */
	@RequestMapping(value="/notifyUrlWeixin")
	public void notifyWeixinPayment(HttpServletRequest request,HttpServletResponse response){
		try {
			BufferedReader reader = request.getReader();
			String line = "";
			StringBuffer inputString = new StringBuffer();

			PrintWriter writer = response.getWriter();
			while ((line = reader.readLine()) != null) {
				inputString.append(line);
			}
			if (reader != null) {
				reader.close();
			}
			if (!StringUtils.isEmpty(inputString.toString())) {
				//增加支付日志
				WXPayResult wxPayResult = JdomParseXmlUtils.getWXPayResult(inputString.toString());
				//保存回调的支付日志
//				paymentPayLogService.updatePayInfo(wxPayResult.getOut_trade_no(), wxPayResult.getTransaction_id(), inputString.toString());
				if ("SUCCESS".equalsIgnoreCase(wxPayResult.getReturn_code())) {
				    boolean result=WXSignUtils.isWechatSign(WXSignUtils.dom4jXMLParse(inputString.toString()));
					String orderId = wxPayResult.getOut_trade_no();
					try {
						if (result) {
							//修改订单的状态
							PaymentOrder order = paymentOrderService.get(orderId);
							if (order != null && order.getPaymentState().equals("1") && !StringUtils.isEmpty(order.getOrderCode())) {
								//修改支付方式
								order.setPaymentWay("24");//24代表微信支付
								order.setTransactionId(wxPayResult.getTransaction_id());
								//会员端支付后处理逻辑
								orderService.afterPay(order);
								//修改支付日志支付状态
//								paymentPayLogService.updatePayState(orderId, "2", null);
							} else if(order != null && order.getPaymentState().equals("2") && !StringUtils.isEmpty(order.getOrderCode())){
								logger.info("用户支付成功，订单已经处理过");
							} else {
								logger.error("用户支付成功，但是处理失败，没有找到待处理订单");
								//修改支付日志支付状态
//								paymentPayLogService.updatePayState(orderId, "3", "用户支付成功，但是处理失败，没有找到待处理订单");
							}
							writer.write(HttpXmlUtils.backWeixin("SUCCESS", "OK"));
						} else {
							writer.write(HttpXmlUtils.backWeixin("FAIL", "签名失败"));
//							logger.error("---------微信支付验证签名失败----------");
							//修改支付日志支付状态
//							paymentPayLogService.updatePayState(orderId, "3", "验证签名失败");
						}
					} catch (Exception e){
						//修改支付日志支付状态
//						paymentPayLogService.updatePayState(orderId, "3", ExceptionUtil.printStackTrace(e));
						logger.error("----微信支付处理失败---", e);
					}
				} else {
					writer.write(HttpXmlUtils.backWeixin("FAIL", wxPayResult.getReturn_msg()));
					//修改支付日志支付状态
//					paymentPayLogService.updatePayState(wxPayResult.getOut_trade_no(), "3", "返回码错误：" + wxPayResult.getReturn_msg());
					logger.error("---------微信支付返回Fail----------" + wxPayResult.getReturn_msg());
				}
				if (writer != null) {
					writer.close();
				}
			} else {
				writer.write(HttpXmlUtils.backWeixin("FAIL", "未获取到微信返回的结果"));
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
