/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 收费项目Entity
 *
 * @author lyy
 * @version 2016-07-21
 */
public class PaymentChargingItem extends DataEntity<PaymentChargingItem> {

	private static final long serialVersionUID = 1L;
	private String name; // 收费项目名
	private String shortName; // 相应的业务表名@各自状态的标示
	private String price; // 金额
	private String isShare; // 是否分摊 后台扣费用
	private String shareSection; // 分摊区间 月份为单位
	private String preferentialFlag;
	private String sort; // 排序字段
	private String visibility; // 会员可见度
	private String type; // 是否能够跳转
	private String jumpUrl; // 跳转路径
	private String showUrl; // 跳转路径

	private Date startDate; // 拆分数据使用
	private Date endDate; // 拆分数据使用

	private String dept;

	public String getDept() {
		return dept;
	}

	public void setDept(String dept) {
		this.dept = dept;
	}

	public PaymentChargingItem() {
		super();
	}

	public PaymentChargingItem(String id) {
		super(id);
	}

	@Length(min = 0, max = 100, message = "收费项目名长度必须介于 0 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 50, message = "相应的业务表名@各自状态的标示长度必须介于 0 和 50 之间")
	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 11, message = "排序字段长度必须介于 0 和 11 之间")
	public String getSort() {
		return sort;
	}

	public void setSort(String sort) {
		this.sort = sort;
	}

	@Length(min = 0, max = 1, message = "会员可见度长度必须介于 0 和 1 之间")
	public String getVisibility() {
		return visibility;
	}

	public void setVisibility(String visibility) {
		this.visibility = visibility;
	}

	@Length(min = 0, max = 1, message = "项目类型必须介于 0 和 1 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min = 0, max = 100, message = "订单录入路径必须介于 0 和 100 之间")
	public String getJumpUrl() {
		return jumpUrl;
	}

	public void setJumpUrl(String jumpUrl) {
		this.jumpUrl = jumpUrl;
	}

	@Length(min = 0, max = 100, message = "订单展现路径必须介于 0 和 100 之间")
	public String getShowUrl() {
		return showUrl;
	}

	public void setShowUrl(String showUrl) {
		this.showUrl = showUrl;
	}

	public String getIsShare() {
		return isShare;
	}

	public void setIsShare(String isShare) {
		this.isShare = isShare;
	}

	public String getShareSection() {
		return shareSection;
	}

	public void setShareSection(String shareSection) {
		this.shareSection = shareSection;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getPreferentialFlag() {
		return preferentialFlag;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public void setPreferentialFlag(String preferentialFlag) {
		this.preferentialFlag = preferentialFlag;
	}

}
