/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.offlineorder.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cab.passport.offlineorder.entity.OfflineOrder;
import com.cab.passport.offlineorder.dao.OfflineOrderDao;

/**
 * 线下订单汇总表Service
 * @author xx
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class OfflineOrderService extends CrudService<OfflineOrderDao, OfflineOrder> {

	public OfflineOrder get(String id) {
		return super.get(id);
	}
	
	public List<OfflineOrder> findList(OfflineOrder offlineOrder) {
		return super.findList(offlineOrder);
	}
	
	public Page<OfflineOrder> findPage(Page<OfflineOrder> page, OfflineOrder offlineOrder) {
		return super.findPage(page, offlineOrder);
	}
	
	@Transactional(readOnly = false)
	public void save(OfflineOrder offlineOrder) {
		super.save(offlineOrder);
	}
	
	@Transactional(readOnly = false)
	public void delete(OfflineOrder offlineOrder) {
		super.delete(offlineOrder);
	}
	
}