/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.votes.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cab.passport.votes.entity.Votes;
import com.cab.passport.votes.service.VotesService;

/**
 * votesController
 * @author wj
 * @version 2020-05-12
 */
@Controller
@RequestMapping(value = "${adminPath}/votes/votes")
public class VotesController extends BaseController {

	@Autowired
	private VotesService votesService;
	
	@ModelAttribute
	public Votes get(@RequestParam(required=false) String id) {
		Votes entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = votesService.get(id);
		}
		if (entity == null){
			entity = new Votes();
		}
		return entity;
	}
	
	@RequiresPermissions("votes:votes:view")
	@RequestMapping(value = {"list", ""})
	public String list(Votes votes, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Votes> page = votesService.findPage(new Page<Votes>(request, response), votes); 
		model.addAttribute("page", page);
		return "passport/votes/votesList";
	}

	@RequiresPermissions("votes:votes:view")
	@RequestMapping(value = "form")
	public String form(Votes votes, Model model) {
		model.addAttribute("votes", votes);
		return "passport/votes/votesForm";
	}

	@RequiresPermissions("votes:votes:edit")
	@RequestMapping(value = "save")
	public String save(Votes votes, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, votes)){
			return form(votes, model);
		}
		votesService.save(votes);
		addMessage(redirectAttributes, "保存votes成功");
		return "redirect:"+Global.getAdminPath()+"/votes/votes/?repage";
	}
	
	@RequiresPermissions("votes:votes:edit")
	@RequestMapping(value = "delete")
	public String delete(Votes votes, RedirectAttributes redirectAttributes) {
		votesService.delete(votes);
		addMessage(redirectAttributes, "删除votes成功");
		return "redirect:"+Global.getAdminPath()+"/votes/votes/?repage";
	}

}